/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.servlet.BaseHttpServletResponseXmlMessageEncoder;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.BindingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.encoding.SAMLMessageEncoder;
import org.opensaml.saml.common.context.SamlSigningContext;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.opensaml.xmlsec.signature.support.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSAML2MessageEncoder
extends BaseHttpServletResponseXmlMessageEncoder<SAMLObject>
implements SAMLMessageEncoder {
    private final Logger log = LoggerFactory.getLogger(BaseSAML2MessageEncoder.class);
    private List<String> allowedURLSchemes;

    public BaseSAML2MessageEncoder() {
        this.setAllowedURLSchemes(new String[]{"http", "https"});
    }

    public List<String> getAllowedURLSchemes() {
        return this.allowedURLSchemes;
    }

    public void setAllowedURLSchemes(String[] schemes) {
        if (schemes == null || schemes.length == 0) {
            this.allowedURLSchemes = Collections.emptyList();
        } else {
            ArrayList<String> temp = new ArrayList<String>();
            for (String scheme : schemes) {
                temp.add(scheme);
            }
            this.allowedURLSchemes = Collections.unmodifiableList(temp);
        }
    }

    protected URI getEndpointURL(MessageContext<SAMLObject> messageContext) throws MessageEncodingException {
        URI endpointUrl;
        try {
            endpointUrl = SAMLBindingSupport.getEndpointURL(messageContext);
        }
        catch (BindingException e) {
            throw new MessageEncodingException("Could not obtain message endpoint URL", (Exception)((Object)e));
        }
        if (!this.getAllowedURLSchemes().contains(endpointUrl.getScheme())) {
            throw new MessageEncodingException("Relying party endpoint used the untrusted URL scheme " + endpointUrl.getScheme());
        }
        return endpointUrl;
    }

    protected void setResponseDestination(SAMLObject outboundMessage, String endpointURL) {
        if (outboundMessage instanceof StatusResponseType) {
            ((StatusResponseType)outboundMessage).setDestination(endpointURL);
        }
    }

    protected void signMessage(MessageContext<SAMLObject> messageContext) throws MessageEncodingException {
        SAMLObject outboundSAML = (SAMLObject)messageContext.getMessage();
        Credential signingCredential = this.getContextSigningCredential(messageContext);
        if (outboundSAML instanceof SignableSAMLObject && signingCredential != null) {
            SignableSAMLObject signableMessage = (SignableSAMLObject)outboundSAML;
            XMLObjectBuilder signatureBuilder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME);
            Signature signature = (Signature)signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential(signingCredential);
            try {
                SignatureSupport.prepareSignatureParams((Signature)signature, (Credential)signingCredential, null, null);
            }
            catch (SecurityException e) {
                throw new MessageEncodingException("Error preparing signature for signing", (Exception)((Object)e));
            }
            signableMessage.setSignature(signature);
            try {
                Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)signableMessage);
                if (marshaller == null) {
                    throw new MessageEncodingException("No marshaller registered for " + signableMessage.getElementQName() + ", unable to marshall in preperation for signing");
                }
                marshaller.marshall((XMLObject)signableMessage);
                Signer.signObject((Signature)signature);
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall protocol message in preparation for signing", (Throwable)e);
                throw new MessageEncodingException("Unable to marshall protocol message in preparation for signing", (Exception)((Object)e));
            }
            catch (SignatureException e) {
                this.log.error("Unable to sign protocol message", (Throwable)e);
                throw new MessageEncodingException("Unable to sign protocol message", (Exception)((Object)e));
            }
        }
    }

    @Nullable
    protected Credential getContextSigningCredential(MessageContext<SAMLObject> messageContext) {
        SignatureSigningConfiguration configuration;
        SamlSigningContext context = (SamlSigningContext)messageContext.getSubcontext(SamlSigningContext.class);
        if (context != null && (configuration = context.getSigningConfiguration()) != null) {
            return configuration.getSigningCredential();
        }
        return null;
    }
}

