/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.decoding;

import java.io.ByteArrayInputStream;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXmlMessageDecoder;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml.common.context.SamlProtocolContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPPostDecoder
extends BaseHttpServletRequestXmlMessageDecoder<SAMLObject>
implements SAMLMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(HTTPPostDecoder.class);

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:1.0:profiles:browser-post";
    }

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        HttpServletRequest request = this.getHttpServletRequest();
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            throw new MessageDecodingException("This message deocoder only supports the HTTP POST method");
        }
        String relayState = request.getParameter("TARGET");
        this.log.debug("Decoded SAML relay state (TARGET parameter) of: {}", (Object)relayState);
        ((SamlProtocolContext)messageContext.getSubcontext(SamlProtocolContext.class, true)).setRelayState(relayState);
        String base64Message = request.getParameter("SAMLResponse");
        byte[] decodedBytes = Base64Support.decode((String)base64Message);
        if (decodedBytes == null) {
            this.log.error("Unable to Base64 decode SAML message");
            throw new MessageDecodingException("Unable to Base64 decode SAML message");
        }
        SAMLObject inboundMessage = (SAMLObject)this.unmarshallMessage(new ByteArrayInputStream(decodedBytes));
        messageContext.setMessage((Object)inboundMessage);
        this.log.debug("Decoded SAML message");
        this.setMessageContext(messageContext);
    }
}

