/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.decoding;

import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXmlMessageDecoder;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml.common.context.SamlProtocolContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPArtifactDecoder
extends BaseHttpServletRequestXmlMessageDecoder<SAMLObject>
implements SAMLMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(HTTPArtifactDecoder.class);

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01";
    }

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        HttpServletRequest request = this.getHttpServletRequest();
        this.decodeTarget(messageContext, request);
        this.processArtifacts(messageContext, request);
        this.setMessageContext(messageContext);
    }

    protected void decodeTarget(MessageContext messageContext, HttpServletRequest request) throws MessageDecodingException {
        String target = StringSupport.trim((String)request.getParameter("TARGET"));
        if (target == null) {
            this.log.error("URL TARGET parameter was missing or did not contain a value.");
            throw new MessageDecodingException("URL TARGET parameter was missing or did not contain a value.");
        }
        ((SamlProtocolContext)messageContext.getSubcontext(SamlProtocolContext.class, true)).setRelayState(target);
    }

    protected void processArtifacts(MessageContext messageContext, HttpServletRequest request) throws MessageDecodingException {
        String[] encodedArtifacts = request.getParameterValues("SAMLart");
        if (encodedArtifacts == null || encodedArtifacts.length == 0) {
            this.log.error("URL SAMLart parameter was missing or did not contain a value.");
            throw new MessageDecodingException("URL SAMLart parameter was missing or did not contain a value.");
        }
    }
}

