/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security;

import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.saml.common.binding.SAMLMessageContext;
import org.opensaml.saml.security.MetadataCriterion;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.provider.CertificateNameOptions;
import org.opensaml.ws.security.provider.ClientCertAuthRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLMDClientCertAuthRule
extends ClientCertAuthRule {
    private final Logger log = LoggerFactory.getLogger(SAMLMDClientCertAuthRule.class);

    public SAMLMDClientCertAuthRule(TrustEngine<X509Credential> engine, CertificateNameOptions nameOptions) {
        super(engine, nameOptions);
    }

    protected CriteriaSet buildCriteriaSet(String entityID, MessageContext messageContext) throws SecurityPolicyException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Supplied message context was not an instance of SAMLMessageContext, can not build criteria set from SAML metadata parameters");
            throw new SecurityPolicyException("Supplied message context was not an instance of SAMLMessageContext");
        }
        SAMLMessageContext samlContext = (SAMLMessageContext)messageContext;
        CriteriaSet criteriaSet = super.buildCriteriaSet(entityID, messageContext);
        MetadataCriterion mdCriteria = new MetadataCriterion(samlContext.getPeerEntityRole(), samlContext.getInboundSAMLProtocol());
        criteriaSet.add((Object)mdCriteria);
        return criteriaSet;
    }
}

