/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.ldaptive.LdapUtils;
import org.ldaptive.ssl.AbstractSSLContextInitializer;

public class X509SSLContextInitializer
extends AbstractSSLContextInitializer {
    private X509Certificate[] trustCerts;
    private X509Certificate authenticationCert;
    private PrivateKey authenticationKey;

    public X509Certificate[] getTrustCertificates() {
        return this.trustCerts;
    }

    public void setTrustCertificates(X509Certificate ... certs) {
        this.trustCerts = certs;
    }

    public X509Certificate getAuthenticationCertificate() {
        return this.authenticationCert;
    }

    public void setAuthenticationCertificate(X509Certificate cert) {
        this.authenticationCert = cert;
    }

    public PrivateKey getAuthenticationKey() {
        return this.authenticationKey;
    }

    public void setAuthenticationKey(PrivateKey key) {
        this.authenticationKey = key;
    }

    @Override
    public TrustManager[] getTrustManagers() throws GeneralSecurityException {
        TrustManager[] tm = null;
        if (this.trustCerts != null && this.trustCerts.length > 0) {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            try {
                ks.load(null, null);
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e);
            }
            for (int i = 0; i < this.trustCerts.length; ++i) {
                ks.setCertificateEntry("ldap_trust_" + i, this.trustCerts[i]);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            tm = tmf.getTrustManagers();
        }
        TrustManager[] aggregate = tm == null ? (super.getTrustManagers() != null ? this.aggregateTrustManagers(super.getTrustManagers()) : null) : this.aggregateTrustManagers(LdapUtils.concatArrays(tm, new TrustManager[][]{super.getTrustManagers()}));
        return aggregate;
    }

    @Override
    public KeyManager[] getKeyManagers() throws GeneralSecurityException {
        KeyManager[] km = null;
        if (this.authenticationCert != null && this.authenticationKey != null) {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            try {
                ks.load(null, null);
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e);
            }
            ks.setKeyEntry("ldap_client_auth", this.authenticationKey, "changeit".toCharArray(), new X509Certificate[]{this.authenticationCert});
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, "changeit".toCharArray());
            km = kmf.getKeyManagers();
        }
        return km;
    }
}

