/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.security.GeneralSecurityException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.ldaptive.ssl.DefaultHostnameVerifier;
import org.ldaptive.ssl.HostnameVerifyingTrustManager;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.TLSSocketFactory;

public class ThreadLocalTLSSocketFactory
extends TLSSocketFactory {
    private static final ThreadLocalSslConfig THREAD_LOCAL_SSL_CONFIG = new ThreadLocalSslConfig();

    @Override
    public SslConfig getSslConfig() {
        return (SslConfig)THREAD_LOCAL_SSL_CONFIG.get();
    }

    @Override
    public void setSslConfig(SslConfig config) {
        THREAD_LOCAL_SSL_CONFIG.set(config);
    }

    public static SocketFactory getDefault() {
        ThreadLocalTLSSocketFactory sf = new ThreadLocalTLSSocketFactory();
        if (sf.getSslConfig() == null) {
            throw new NullPointerException("Thread local SslConfig has not been set");
        }
        try {
            sf.initialize();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Error initializing socket factory", e);
        }
        return sf;
    }

    public static SSLSocketFactory getHostnameVerifierFactory(SslConfig config, String[] names) {
        ThreadLocalTLSSocketFactory sf = new ThreadLocalTLSSocketFactory();
        if (config != null && !config.isEmpty()) {
            sf.setSslConfig(SslConfig.newSslConfig(config));
            if (sf.getSslConfig().getTrustManagers() == null) {
                sf.getSslConfig().setTrustManagers(new HostnameVerifyingTrustManager(new DefaultHostnameVerifier(), names));
            }
        } else {
            sf.setSslConfig(new SslConfig(new HostnameVerifyingTrustManager(new DefaultHostnameVerifier(), names)));
        }
        try {
            sf.initialize();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
        return sf;
    }

    @Override
    public String toString() {
        return String.format("[%s@%d::factory=%s, sslConfig=%s]", this.getClass().getName(), this.hashCode(), this.getFactory(), this.getSslConfig());
    }

    private static class ThreadLocalSslConfig
    extends ThreadLocal<SslConfig> {
        private ThreadLocalSslConfig() {
        }
    }
}

