/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.security.GeneralSecurityException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.ldaptive.ssl.AbstractTLSSocketFactory;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.DefaultHostnameVerifier;
import org.ldaptive.ssl.DefaultSSLContextInitializer;
import org.ldaptive.ssl.HostnameVerifyingTrustManager;
import org.ldaptive.ssl.SSLContextInitializer;
import org.ldaptive.ssl.SslConfig;

public class TLSSocketFactory
extends AbstractTLSSocketFactory {
    @Override
    public void initialize() throws GeneralSecurityException {
        SSLContextInitializer contextInitializer;
        SslConfig sslConfig = this.getSslConfig();
        if (sslConfig != null) {
            CredentialConfig credConfig = sslConfig.getCredentialConfig();
            contextInitializer = credConfig != null ? credConfig.createSSLContextInitializer() : new DefaultSSLContextInitializer();
            TrustManager[] managers = sslConfig.getTrustManagers();
            if (managers != null) {
                contextInitializer.setTrustManagers(managers);
            }
        } else {
            contextInitializer = new DefaultSSLContextInitializer();
        }
        SSLContext ctx = contextInitializer.initSSLContext("TLS");
        this.factory = ctx.getSocketFactory();
    }

    public static SocketFactory getDefault() {
        TLSSocketFactory sf = new TLSSocketFactory();
        try {
            sf.initialize();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Error initializing socket factory", e);
        }
        return sf;
    }

    public static SSLSocketFactory getHostnameVerifierFactory(SslConfig config, String[] names) {
        TLSSocketFactory sf = new TLSSocketFactory();
        if (config != null && !config.isEmpty()) {
            sf.setSslConfig(SslConfig.newSslConfig(config));
            if (sf.getSslConfig().getTrustManagers() == null) {
                sf.getSslConfig().setTrustManagers(new HostnameVerifyingTrustManager(new DefaultHostnameVerifier(), names));
            }
        } else {
            sf.setSslConfig(new SslConfig(new HostnameVerifyingTrustManager(new DefaultHostnameVerifier(), names)));
        }
        try {
            sf.initialize();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
        return sf;
    }

    public String toString() {
        return String.format("[%s@%d::factory=%s, sslConfig=%s]", this.getClass().getName(), this.hashCode(), this.getFactory(), this.getSslConfig());
    }
}

