/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.ldaptive.LdapUtils;
import org.ldaptive.ssl.AbstractSSLContextInitializer;

public class KeyStoreSSLContextInitializer
extends AbstractSSLContextInitializer {
    private KeyStore trustKeystore;
    private KeyStore authenticationKeystore;
    private char[] authenticationPassword;

    public void setTrustKeystore(KeyStore keystore) {
        this.trustKeystore = keystore;
    }

    public void setAuthenticationKeystore(KeyStore keystore) {
        this.authenticationKeystore = keystore;
    }

    public void setAuthenticationPassword(char[] password) {
        this.authenticationPassword = password;
    }

    @Override
    public TrustManager[] getTrustManagers() throws GeneralSecurityException {
        TrustManager[] tm = null;
        if (this.trustKeystore != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.trustKeystore);
            tm = tmf.getTrustManagers();
        }
        TrustManager[] aggregate = tm == null ? (super.getTrustManagers() != null ? this.aggregateTrustManagers(super.getTrustManagers()) : null) : this.aggregateTrustManagers(LdapUtils.concatArrays(tm, new TrustManager[][]{super.getTrustManagers()}));
        return aggregate;
    }

    @Override
    public KeyManager[] getKeyManagers() throws GeneralSecurityException {
        KeyManager[] km = null;
        if (this.authenticationKeystore != null && this.authenticationPassword != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(this.authenticationKeystore, this.authenticationPassword);
            km = kmf.getKeyManagers();
        }
        return km;
    }
}

