/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateTrustManager
implements X509TrustManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final X509TrustManager[] trustManagers;

    public AggregateTrustManager(X509TrustManager ... managers) {
        this.trustManagers = managers;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.trustManagers != null) {
            for (X509TrustManager tm : this.trustManagers) {
                this.logger.debug("invoking checkClientTrusted for {}", (Object)tm);
                tm.checkClientTrusted(chain, authType);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.trustManagers != null) {
            for (X509TrustManager tm : this.trustManagers) {
                this.logger.debug("invoking checkServerTrusted for {}", (Object)tm);
                tm.checkServerTrusted(chain, authType);
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList issuers = new ArrayList();
        if (this.trustManagers != null) {
            for (X509TrustManager tm : this.trustManagers) {
                this.logger.debug("invoking getAcceptedIssuers invoked for {}", (Object)tm);
                Collections.addAll(issuers, tm.getAcceptedIssuers());
            }
        }
        return issuers.toArray(new X509Certificate[issuers.size()]);
    }

    public String toString() {
        return String.format("[%s@%d::trustManagers=%s]", this.getClass().getName(), this.hashCode(), Arrays.toString(this.trustManagers));
    }
}

