/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.ldaptive.ssl.SocketConfig;
import org.ldaptive.ssl.SslConfig;

public abstract class AbstractTLSSocketFactory
extends SSLSocketFactory {
    public static final String DEFAULT_PROTOCOL = "TLS";
    protected SSLSocketFactory factory;
    private SslConfig sslConfig;
    private HostnameVerifier hostnameVerifier;
    private SocketConfig socketConfig;

    public abstract void initialize() throws GeneralSecurityException;

    public SSLSocketFactory getFactory() {
        return this.factory;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(SslConfig config) {
        this.sslConfig = config;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
    }

    public SocketConfig getSocketConfig() {
        return this.socketConfig;
    }

    public void setSocketConfig(SocketConfig config) {
        this.socketConfig = config;
    }

    protected SSLSocket initSSLSocket(SSLSocket socket) throws IOException {
        String hostname;
        SslConfig sslC;
        SocketConfig socketC = this.getSocketConfig();
        if (socketC != null) {
            socketC.configureSocket(socket);
        }
        if ((sslC = this.getSslConfig()) != null) {
            if (sslC.getEnabledCipherSuites() != null) {
                socket.setEnabledCipherSuites(sslC.getEnabledCipherSuites());
            }
            if (sslC.getEnabledProtocols() != null) {
                socket.setEnabledProtocols(sslC.getEnabledProtocols());
            }
            if (sslC.getHandshakeCompletedListeners() != null) {
                for (HandshakeCompletedListener listener : sslC.getHandshakeCompletedListeners()) {
                    socket.addHandshakeCompletedListener(listener);
                }
            }
        }
        if (this.hostnameVerifier != null && !this.hostnameVerifier.verify(hostname = socket.getSession().getPeerHost(), socket.getSession())) {
            socket.close();
            socket.getSession().invalidate();
            throw new SSLPeerUnverifiedException(String.format("Hostname '%s' does not match the hostname in the server's certificate", hostname));
        }
        return socket;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.initSSLSocket((SSLSocket)this.factory.createSocket(socket, host, port, autoClose));
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.initSSLSocket((SSLSocket)this.factory.createSocket());
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.initSSLSocket((SSLSocket)this.factory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.initSSLSocket((SSLSocket)this.factory.createSocket(address, port, localAddress, localPort));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.initSSLSocket((SSLSocket)this.factory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.initSSLSocket((SSLSocket)this.factory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

