/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.ldaptive.ssl.AggregateTrustManager;
import org.ldaptive.ssl.SSLContextInitializer;

public abstract class AbstractSSLContextInitializer
implements SSLContextInitializer {
    private TrustManager[] trustManagers;

    @Override
    public TrustManager[] getTrustManagers() throws GeneralSecurityException {
        return this.trustManagers;
    }

    @Override
    public void setTrustManagers(TrustManager ... managers) {
        this.trustManagers = managers;
    }

    @Override
    public SSLContext initSSLContext(String protocol) throws GeneralSecurityException {
        SSLContext ctx = SSLContext.getInstance(protocol);
        ctx.init(this.getKeyManagers(), this.getTrustManagers(), null);
        return ctx;
    }

    protected TrustManager[] aggregateTrustManagers(TrustManager ... managers) {
        X509TrustManager[] x509Managers = null;
        if (managers != null) {
            x509Managers = new X509TrustManager[managers.length];
            for (int i = 0; i < managers.length; ++i) {
                x509Managers[i] = (X509TrustManager)managers[i];
            }
        }
        return new TrustManager[]{new AggregateTrustManager(x509Managers)};
    }
}

