/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.servlets;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ldaptive.SearchResult;
import org.ldaptive.io.Dsmlv1Writer;
import org.ldaptive.io.LdapResultWriter;
import org.ldaptive.io.LdifWriter;
import org.ldaptive.servlets.AbstractServlet;

public final class SearchServlet
extends AbstractServlet {
    public static final String OUTPUT_FORMAT = "outputFormat";
    public static final String DEFAULT_OUTPUT_FORMAT = "DSML";
    private static final long serialVersionUID = 3437252581014900696L;
    private OutputType output;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String outputType = this.getInitParameter(OUTPUT_FORMAT);
        if (outputType == null) {
            outputType = DEFAULT_OUTPUT_FORMAT;
        }
        this.logger.debug("{} = {}", (Object)OUTPUT_FORMAT, (Object)outputType);
        this.output = OutputType.valueOf(outputType);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("search={} for attributes={}", (Object)request.getParameter("query"), (Object)request.getParameter("attrs"));
        try {
            LdapResultWriter writer;
            SearchResult result = this.search(request.getParameter("query"), request.getParameterValues("attrs"));
            if (this.output == OutputType.LDIF) {
                response.setContentType("text/plain");
                writer = new LdifWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream())));
            } else {
                String content = request.getParameter("content-type");
                if ("text".equalsIgnoreCase(content)) {
                    response.setContentType("text/plain");
                } else {
                    response.setContentType("text/xml");
                }
                writer = new Dsmlv1Writer(new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream())));
            }
            writer.write(result);
        }
        catch (Exception e) {
            this.logger.error("Error performing search", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private static enum OutputType {
        LDIF,
        DSML;

    }
}

