/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.jndi;

import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.LdapURL;
import org.ldaptive.provider.AbstractProviderConnectionFactory;
import org.ldaptive.provider.Provider;
import org.ldaptive.provider.ProviderConnectionFactory;
import org.ldaptive.provider.jndi.JndiConnectionFactory;
import org.ldaptive.provider.jndi.JndiProviderConfig;
import org.ldaptive.provider.jndi.JndiStartTLSConnectionFactory;
import org.ldaptive.ssl.TLSSocketFactory;
import org.ldaptive.ssl.ThreadLocalTLSSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiProvider
implements Provider<JndiProviderConfig> {
    public static final String CONTEXT_FACTORY = "java.naming.factory.initial";
    public static final String VERSION = "java.naming.ldap.version";
    public static final String PROVIDER_URL = "java.naming.provider.url";
    public static final String PROTOCOL = "java.naming.security.protocol";
    public static final String SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    public static final String CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    public static final String READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    public static final String TRACE = "com.sun.jndi.ldap.trace.ber";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private JndiProviderConfig config = new JndiProviderConfig();

    @Override
    public ProviderConnectionFactory<JndiProviderConfig> getConnectionFactory(ConnectionConfig cc) {
        AbstractProviderConnectionFactory cf = cc.getUseStartTLS() ? this.getJndiStartTLSConnectionFactory(cc, this.config.getEnvironment()) : this.getJndiConnectionFactory(cc, this.config.getEnvironment());
        return cf;
    }

    @Override
    public JndiProviderConfig getProviderConfig() {
        return this.config;
    }

    @Override
    public void setProviderConfig(JndiProviderConfig jpc) {
        this.config = jpc;
    }

    public JndiProvider newInstance() {
        return new JndiProvider();
    }

    protected JndiStartTLSConnectionFactory getJndiStartTLSConnectionFactory(ConnectionConfig cc, Map<String, Object> env) {
        SSLSocketFactory factory = this.config.getSslSocketFactory();
        if (factory == null && cc.getSslConfig() != null && !cc.getSslConfig().isEmpty()) {
            TLSSocketFactory sf = new TLSSocketFactory();
            sf.setSslConfig(cc.getSslConfig());
            try {
                sf.initialize();
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException(e);
            }
            factory = sf;
        }
        return new JndiStartTLSConnectionFactory(cc.getLdapUrl(), this.config, env != null ? env : this.getDefaultEnvironment(cc, null), factory, this.config.getHostnameVerifier());
    }

    protected JndiConnectionFactory getJndiConnectionFactory(ConnectionConfig cc, Map<String, Object> env) {
        SSLSocketFactory factory = this.config.getSslSocketFactory();
        if (factory == null && (cc.getUseSSL() || cc.getLdapUrl().toLowerCase().contains("ldaps://"))) {
            LdapURL ldapUrl = new LdapURL(cc.getLdapUrl());
            factory = ThreadLocalTLSSocketFactory.getHostnameVerifierFactory(cc.getSslConfig(), ldapUrl.getEntriesAsString());
        }
        return new JndiConnectionFactory(cc.getLdapUrl(), this.config, env != null ? env : this.getDefaultEnvironment(cc, factory != null ? factory.getClass().getName() : null));
    }

    protected Map<String, Object> getDefaultEnvironment(ConnectionConfig cc, String factory) {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put(CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
        env.put(VERSION, "3");
        if (cc.getUseSSL()) {
            env.put(PROTOCOL, "ssl");
        }
        if (factory != null && (cc.getUseSSL() || cc.getLdapUrl().toLowerCase().contains("ldaps://"))) {
            env.put(SOCKET_FACTORY, factory);
        }
        if (cc.getConnectTimeout() > 0L) {
            env.put(CONNECT_TIMEOUT, Long.toString(cc.getConnectTimeout()));
        }
        if (cc.getResponseTimeout() > 0L) {
            env.put(READ_TIMEOUT, Long.toString(cc.getResponseTimeout()));
        }
        if (this.config.getTracePackets() != null) {
            env.put(TRACE, this.config.getTracePackets());
        }
        if (!this.config.getProperties().isEmpty()) {
            for (Map.Entry<String, Object> entry : this.config.getProperties().entrySet()) {
                env.put(entry.getKey(), entry.getValue());
            }
        }
        return env;
    }
}

