/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.util.concurrent.TimeUnit;
import org.ldaptive.pool.PooledConnectionProxy;
import org.ldaptive.pool.PruneStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdlePruneStrategy
implements PruneStrategy {
    private static final int DEFAULT_STATISTICS_SIZE = 1;
    private static final long DEFAULT_PRUNE_PERIOD = 300L;
    private static final long DEFAULT_IDLE_TIME = 600L;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private long prunePeriod;
    private long idleTime;

    public IdlePruneStrategy() {
        this(300L, 600L);
    }

    public IdlePruneStrategy(long period, long idle) {
        this.prunePeriod = period;
        this.idleTime = idle;
    }

    @Override
    public boolean prune(PooledConnectionProxy conn) {
        long timeAvailable = conn.getPooledConnectionStatistics().getLastAvailableState();
        this.logger.trace("evaluating timestamp {} for connection {}", (Object)timeAvailable, (Object)conn);
        return System.currentTimeMillis() - timeAvailable > TimeUnit.SECONDS.toMillis(this.idleTime);
    }

    @Override
    public int getStatisticsSize() {
        return 1;
    }

    @Override
    public long getPrunePeriod() {
        return this.prunePeriod;
    }

    public void setPrunePeriod(long period) {
        this.prunePeriod = period;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(long time) {
        this.idleTime = time;
    }

    public String toString() {
        return String.format("[%s@%d::prunePeriod=%s, idleTime=%s]", this.getClass().getName(), this.hashCode(), this.prunePeriod, this.idleTime);
    }
}

