/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.jaas;

import java.util.HashMap;
import java.util.Map;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionFactoryManager;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.SearchRequest;
import org.ldaptive.jaas.AbstractPropertiesFactory;
import org.ldaptive.jaas.RoleResolver;
import org.ldaptive.jaas.RoleResolverFactory;
import org.ldaptive.jaas.SearchRoleResolver;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.PooledConnectionFactoryManager;
import org.ldaptive.props.AbstractPropertySource;
import org.ldaptive.props.DefaultConnectionFactoryPropertySource;
import org.ldaptive.props.PooledConnectionFactoryPropertySource;
import org.ldaptive.props.PropertySource;
import org.ldaptive.props.SearchRequestPropertySource;

public class PropertiesRoleResolverFactory
extends AbstractPropertiesFactory
implements RoleResolverFactory {
    private static final Map<String, RoleResolver> CACHE = new HashMap<String, RoleResolver>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoleResolver createRoleResolver(Map<String, ?> jaasOptions) {
        RoleResolver rr;
        if (jaasOptions.containsKey("cacheId")) {
            String cacheId = (String)jaasOptions.get("cacheId");
            Map<String, RoleResolver> map = CACHE;
            synchronized (map) {
                if (!CACHE.containsKey(cacheId)) {
                    rr = this.createRoleResolverInternal(jaasOptions);
                    this.logger.trace("Created role resolver: {}", (Object)rr);
                    CACHE.put(cacheId, rr);
                } else {
                    rr = CACHE.get(cacheId);
                    this.logger.trace("Retrieved role resolver from CACHE: {}", (Object)rr);
                }
            }
        } else {
            rr = this.createRoleResolverInternal(jaasOptions);
            this.logger.trace("Created role resolver {} from {}", (Object)rr, jaasOptions);
        }
        return rr;
    }

    protected RoleResolver createRoleResolverInternal(Map<String, ?> options) {
        AbstractPropertySource source;
        ConnectionFactory cf;
        Object cfm;
        RoleResolver rr;
        if (options.containsKey("roleResolver")) {
            try {
                String className = (String)options.get("roleResolver");
                rr = (RoleResolver)Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            rr = new SearchRoleResolver();
        }
        if (rr instanceof PooledConnectionFactoryManager) {
            cfm = (PooledConnectionFactoryManager)((Object)rr);
            cf = new PooledConnectionFactory();
            source = new PooledConnectionFactoryPropertySource((PooledConnectionFactory)cf, PropertySource.PropertyDomain.AUTH, PropertiesRoleResolverFactory.createProperties(options));
            ((PooledConnectionFactoryPropertySource)source).initialize();
            cfm.setConnectionFactory((PooledConnectionFactory)cf);
        }
        if (rr instanceof ConnectionFactoryManager) {
            cfm = rr;
            cf = new DefaultConnectionFactory();
            source = new DefaultConnectionFactoryPropertySource((DefaultConnectionFactory)cf, PropertySource.PropertyDomain.AUTH, PropertiesRoleResolverFactory.createProperties(options));
            ((DefaultConnectionFactoryPropertySource)source).initialize();
            cfm.setConnectionFactory(cf);
        }
        return rr;
    }

    @Override
    public SearchRequest createSearchRequest(Map<String, ?> jaasOptions) {
        SearchRequest sr = new SearchRequest();
        SearchRequestPropertySource source = new SearchRequestPropertySource(sr, PropertySource.PropertyDomain.AUTH, PropertiesRoleResolverFactory.createProperties(jaasOptions));
        source.initialize();
        this.logger.trace("Created search request {} from {}", (Object)sr, jaasOptions);
        return sr;
    }

    public static void close() {
        for (RoleResolver rr : CACHE.values()) {
            if (!(rr instanceof PooledConnectionFactoryManager)) continue;
            PooledConnectionFactoryManager cfm = (PooledConnectionFactoryManager)((Object)rr);
            cfm.getConnectionFactory().getConnectionPool().close();
        }
    }
}

