/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchResult;
import org.ldaptive.SortBehavior;
import org.ldaptive.io.LdapResultReader;

public class LdifReader
implements LdapResultReader {
    private final Reader ldifReader;
    private final SortBehavior sortBehavior;

    public LdifReader(Reader reader) {
        this(reader, SortBehavior.getDefaultSortBehavior());
    }

    public LdifReader(Reader reader, SortBehavior sb) {
        this.ldifReader = reader;
        if (sb == null) {
            throw new IllegalArgumentException("Sort behavior cannot be null");
        }
        this.sortBehavior = sb;
    }

    @Override
    public SearchResult read() throws IOException {
        String line;
        SearchResult ldapResult = new SearchResult(this.sortBehavior);
        BufferedReader br = new BufferedReader(this.ldifReader);
        int lineCount = 0;
        LdapEntry ldapEntry = null;
        StringBuffer lineValue = new StringBuffer();
        while ((line = br.readLine()) != null) {
            ++lineCount;
            if (!line.startsWith("dn:")) continue;
            lineValue.append(line);
            ldapEntry = new LdapEntry(this.sortBehavior);
            break;
        }
        boolean read = true;
        while (read) {
            line = br.readLine();
            if (line == null) {
                read = false;
                line = "";
            }
            if (line.startsWith("#")) continue;
            if (line.startsWith("dn:")) {
                ldapResult.addEntry(ldapEntry);
                ldapEntry = new LdapEntry(this.sortBehavior);
            }
            if (line.startsWith(" ")) {
                lineValue.append(line.substring(1));
                continue;
            }
            String s = lineValue.toString();
            if (s.contains(":")) {
                boolean isBinary = false;
                boolean isUrl = false;
                String[] parts = s.split(":", 2);
                String attrName = parts[0];
                String attrValue = parts[1];
                if (attrValue.startsWith(":")) {
                    isBinary = true;
                    attrValue = attrValue.substring(1);
                } else if (attrValue.startsWith("<")) {
                    isUrl = true;
                    attrValue = attrValue.substring(1);
                }
                if (attrValue.startsWith(" ")) {
                    attrValue = attrValue.substring(1);
                }
                if ("dn".equals(attrName)) {
                    ldapEntry.setDn(attrValue);
                } else {
                    LdapAttribute ldapAttr = ldapEntry.getAttribute(attrName);
                    if (ldapAttr == null) {
                        ldapAttr = new LdapAttribute(this.sortBehavior, isBinary || isUrl);
                        ldapAttr.setName(attrName);
                        ldapEntry.addAttribute(ldapAttr);
                    }
                    if (isBinary) {
                        ldapAttr.addBinaryValue(new byte[][]{LdapUtils.base64Decode(attrValue)});
                    } else if (isUrl) {
                        ldapAttr.addBinaryValue(new byte[][]{LdapUtils.readURL(new URL(attrValue))});
                    } else {
                        ldapAttr.addStringValue(attrValue);
                    }
                }
            }
            lineValue = new StringBuffer(line);
        }
        if (ldapEntry != null) {
            ldapResult.addEntry(ldapEntry);
        }
        return ldapResult;
    }
}

