/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.handler;

import org.ldaptive.Connection;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchRequest;
import org.ldaptive.handler.AbstractSearchEntryHandler;

public class CaseChangeEntryHandler
extends AbstractSearchEntryHandler {
    private static final int HASH_CODE_SEED = 821;
    private CaseChange dnCaseChange = CaseChange.NONE;
    private CaseChange attributeNameCaseChange = CaseChange.NONE;
    private CaseChange attributeValueCaseChange = CaseChange.NONE;

    public CaseChange getDnCaseChange() {
        return this.dnCaseChange;
    }

    public void setDnCaseChange(CaseChange cc) {
        this.dnCaseChange = cc;
    }

    public CaseChange getAttributeNameCaseChange() {
        return this.attributeNameCaseChange;
    }

    public void setAttributeNameCaseChange(CaseChange cc) {
        this.attributeNameCaseChange = cc;
    }

    public CaseChange getAttributeValueCaseChange() {
        return this.attributeValueCaseChange;
    }

    public void setAttributeValueCaseChange(CaseChange cc) {
        this.attributeValueCaseChange = cc;
    }

    @Override
    protected String processDn(Connection conn, SearchRequest request, SearchEntry entry) {
        return CaseChange.perform(this.dnCaseChange, entry.getDn());
    }

    @Override
    protected String processAttributeName(Connection conn, SearchRequest request, String name) {
        return CaseChange.perform(this.attributeNameCaseChange, name);
    }

    @Override
    protected String processAttributeValue(Connection conn, SearchRequest request, String value) {
        return CaseChange.perform(this.attributeValueCaseChange, value);
    }

    @Override
    protected byte[] processAttributeValue(Connection conn, SearchRequest request, byte[] value) {
        return value;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(821, new Object[]{this.dnCaseChange, this.attributeNameCaseChange, this.attributeValueCaseChange});
    }

    public static enum CaseChange {
        NONE,
        LOWER,
        UPPER;


        public static String perform(CaseChange cc, String string) {
            String s = null;
            if (LOWER == cc) {
                s = string.toLowerCase();
            } else if (UPPER == cc) {
                s = string.toUpperCase();
            } else if (NONE == cc) {
                s = string;
            }
            return s;
        }
    }
}

