/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.handler;

import java.util.HashSet;
import org.ldaptive.Connection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchRequest;
import org.ldaptive.handler.HandlerResult;
import org.ldaptive.handler.SearchEntryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchEntryHandler
implements SearchEntryHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public HandlerResult<SearchEntry> process(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
        if (entry != null) {
            entry.setDn(this.processDn(conn, request, entry));
            this.processAttributes(conn, request, entry);
        }
        return new HandlerResult<SearchEntry>(entry);
    }

    protected String processDn(Connection conn, SearchRequest request, SearchEntry entry) {
        return entry.getDn();
    }

    protected void processAttributes(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
        for (LdapAttribute la : entry.getAttributes()) {
            this.processAttribute(conn, request, la);
        }
    }

    protected void processAttribute(Connection conn, SearchRequest request, LdapAttribute attr) throws LdapException {
        if (attr != null) {
            attr.setName(this.processAttributeName(conn, request, attr.getName()));
            if (attr.isBinary()) {
                HashSet<byte[]> newValues = new HashSet<byte[]>(attr.size());
                for (byte[] b : attr.getBinaryValues()) {
                    newValues.add(this.processAttributeValue(conn, request, b));
                }
                attr.clear();
                attr.addBinaryValues(newValues);
            } else {
                HashSet<String> newValues = new HashSet<String>(attr.size());
                for (String s : attr.getStringValues()) {
                    newValues.add(this.processAttributeValue(conn, request, s));
                }
                attr.clear();
                attr.addStringValues(newValues);
            }
        }
    }

    protected String processAttributeName(Connection conn, SearchRequest request, String name) {
        return name;
    }

    protected String processAttributeValue(Connection conn, SearchRequest request, String value) {
        return value;
    }

    protected byte[] processAttributeValue(Connection conn, SearchRequest request, byte[] value) {
        return value;
    }

    public boolean equals(Object o) {
        return LdapUtils.areEqual(this, o);
    }

    public abstract int hashCode();
}

