/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.handler;

import java.util.concurrent.TimeUnit;
import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.handler.HandlerResult;
import org.ldaptive.handler.OperationExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRetryOperationExceptionHandler<Q extends Request, S>
implements OperationExceptionHandler<Q, S> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int retry;
    private long retryWait;
    private int retryBackoff;

    public int getRetry() {
        return this.retry;
    }

    public void setRetry(int i) {
        this.logger.trace("setting retry: {}", (Object)i);
        this.retry = i;
    }

    public long getRetryWait() {
        return this.retryWait;
    }

    public void setRetryWait(long time) {
        if (time >= 0L) {
            this.logger.trace("setting retryWait: {}", (Object)time);
            this.retryWait = time;
        }
    }

    public int getRetryBackoff() {
        return this.retryBackoff;
    }

    public void setRetryBackoff(int backoff) {
        this.logger.trace("setting retryBackoff: {}", (Object)backoff);
        this.retryBackoff = backoff;
    }

    @Override
    public HandlerResult<Response<S>> process(Connection conn, Q request, Response<S> response) throws LdapException {
        for (int i = 0; i <= this.retry || this.retry == -1; ++i) {
            try {
                this.processInternal(conn, request, response);
                break;
            }
            catch (LdapException e) {
                this.logger.error("unable to process operation exception", (Throwable)e);
                if (this.retry(i)) continue;
                return new HandlerResult<Object>(null, true);
            }
        }
        return this.createResult(conn, request, response);
    }

    protected abstract void processInternal(Connection var1, Q var2, Response<S> var3) throws LdapException;

    protected abstract HandlerResult<Response<S>> createResult(Connection var1, Q var2, Response<S> var3) throws LdapException;

    protected boolean retry(int count) {
        if (count < this.retry || this.retry == -1) {
            this.logger.warn("Retry attempt {} of {}: wait={}, backoff={}", new Object[]{count + 1, this.retry, this.retryWait, this.retryBackoff});
            if (this.retryWait > 0L) {
                long sleepTime = this.retryWait;
                if (this.retryBackoff > 0 && count > 0) {
                    sleepTime = sleepTime * (long)this.retryBackoff * (long)count;
                }
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(sleepTime));
                }
                catch (InterruptedException ie) {
                    this.logger.debug("Retry wait interrupted", (Throwable)ie);
                }
            }
            return true;
        }
        return false;
    }
}

