/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.extended;

import java.util.ArrayList;
import java.util.Arrays;
import org.ldaptive.AbstractRequest;
import org.ldaptive.Credential;
import org.ldaptive.asn1.ConstructedDEREncoder;
import org.ldaptive.asn1.ContextType;
import org.ldaptive.asn1.DEREncoder;
import org.ldaptive.asn1.UniversalDERTag;
import org.ldaptive.extended.ExtendedRequest;

public class PasswordModifyRequest
extends AbstractRequest
implements ExtendedRequest {
    public static final String OID = "1.3.6.1.4.1.4203.1.11.1";
    private String modifyDn;
    private Credential oldPassword;
    private Credential newPassword;

    public PasswordModifyRequest() {
    }

    public PasswordModifyRequest(String dn) {
        this.setDn(dn);
    }

    public PasswordModifyRequest(String dn, Credential oldPass, Credential newPass) {
        this.setDn(dn);
        this.setOldPassword(oldPass);
        this.setNewPassword(newPass);
    }

    public String getDn() {
        return this.modifyDn;
    }

    public void setDn(String dn) {
        this.modifyDn = dn;
    }

    public Credential getOldPassword() {
        return this.oldPassword;
    }

    public void setOldPassword(Credential oldPass) {
        this.oldPassword = oldPass;
    }

    public Credential getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(Credential newPass) {
        this.newPassword = newPass;
    }

    @Override
    public byte[] encode() {
        ArrayList<ContextType> l = new ArrayList<ContextType>();
        if (this.getDn() != null) {
            l.add(new ContextType(0, this.getDn()));
        }
        if (this.getOldPassword() != null) {
            l.add(new ContextType(1, this.getOldPassword().getString()));
        }
        if (this.getNewPassword() != null) {
            l.add(new ContextType(2, this.getNewPassword().getString()));
        }
        ConstructedDEREncoder se = new ConstructedDEREncoder(UniversalDERTag.SEQ, l.toArray(new DEREncoder[l.size()]));
        return se.encode();
    }

    @Override
    public String getOID() {
        return OID;
    }

    public String toString() {
        return String.format("[%s@%d::modifyDn=%s, controls=%s]", this.getClass().getName(), this.hashCode(), this.modifyDn, Arrays.toString(this.getControls()));
    }
}

