/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control.util;

import org.ldaptive.SearchEntry;
import org.ldaptive.SearchResult;
import org.ldaptive.control.SyncDoneControl;
import org.ldaptive.control.SyncStateControl;
import org.ldaptive.intermediate.SyncInfoMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReplItem {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Entry syncReplEntry;
    private final SyncInfoMessage syncInfoMessage;
    private final Response syncReplResponse;

    public SyncReplItem(Entry entry) {
        this.syncReplEntry = entry;
        this.syncInfoMessage = null;
        this.syncReplResponse = null;
    }

    public SyncReplItem(SyncInfoMessage message) {
        this.syncReplEntry = null;
        this.syncInfoMessage = message;
        this.syncReplResponse = null;
    }

    public SyncReplItem(Response response) {
        this.syncReplEntry = null;
        this.syncInfoMessage = null;
        this.syncReplResponse = response;
    }

    public boolean isEntry() {
        return this.syncReplEntry != null;
    }

    public Entry getEntry() {
        return this.syncReplEntry;
    }

    public boolean isMessage() {
        return this.syncInfoMessage != null;
    }

    public SyncInfoMessage getMessage() {
        return this.syncInfoMessage;
    }

    public boolean isResponse() {
        return this.syncReplResponse != null;
    }

    public Response getResponse() {
        return this.syncReplResponse;
    }

    public String toString() {
        String s = this.isEntry() ? String.format("[%s@%d::syncReplEntry=%s]", this.getClass().getName(), this.hashCode(), this.syncReplEntry) : (this.isMessage() ? String.format("[%s@%d::syncInfoMessage=%s]", this.getClass().getName(), this.hashCode(), this.syncInfoMessage) : (this.isResponse() ? String.format("[%s@%d::syncReplResponse=%s]", this.getClass().getName(), this.hashCode(), this.syncReplResponse) : String.format("[%s@%d]", this.getClass().getName(), this.hashCode())));
        return s;
    }

    public static class Response {
        private final org.ldaptive.Response<SearchResult> response;
        private final SyncDoneControl syncDoneControl;

        public Response(org.ldaptive.Response<SearchResult> res) {
            this.response = res;
            this.syncDoneControl = (SyncDoneControl)this.response.getControl("1.3.6.1.4.1.4203.1.9.1.3");
        }

        public org.ldaptive.Response<SearchResult> getResponse() {
            return this.response;
        }

        public SyncDoneControl getSyncDoneControl() {
            return this.syncDoneControl;
        }

        public String toString() {
            return String.format("[%s@%d::response=%s]", this.getClass().getName(), this.hashCode(), this.response);
        }
    }

    public static class Entry {
        private final SearchEntry searchEntry;
        private final SyncStateControl syncStateControl;

        public Entry(SearchEntry entry) {
            this.searchEntry = entry;
            this.syncStateControl = (SyncStateControl)entry.getControl("1.3.6.1.4.1.4203.1.9.1.2");
        }

        public SearchEntry getSearchEntry() {
            return this.searchEntry;
        }

        public SyncStateControl getSyncStateControl() {
            return this.syncStateControl;
        }

        public String toString() {
            return String.format("[%s@%d::searchEntry=%s]", this.getClass().getName(), this.hashCode(), this.searchEntry);
        }
    }
}

