/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.async.AsyncSearchOperation;
import org.ldaptive.control.SyncRequestControl;
import org.ldaptive.control.util.SyncReplItem;
import org.ldaptive.extended.CancelOperation;
import org.ldaptive.extended.CancelRequest;
import org.ldaptive.handler.HandlerResult;
import org.ldaptive.handler.IntermediateResponseHandler;
import org.ldaptive.handler.OperationResponseHandler;
import org.ldaptive.handler.SearchEntryHandler;
import org.ldaptive.intermediate.IntermediateResponse;
import org.ldaptive.intermediate.SyncInfoMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReplClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Connection connection;
    private final boolean refreshAndPersist;
    private final byte[] syncCookie;

    public SyncReplClient(Connection conn, boolean persist, byte[] cookie) {
        this.connection = conn;
        this.refreshAndPersist = persist;
        this.syncCookie = cookie;
    }

    public BlockingQueue<SyncReplItem> execute(SearchRequest request) throws LdapException {
        final LinkedBlockingQueue<SyncReplItem> queue = new LinkedBlockingQueue<SyncReplItem>();
        AsyncSearchOperation search = new AsyncSearchOperation(this.connection);
        search.setOperationResponseHandlers(new OperationResponseHandler<SearchRequest, SearchResult>(){

            @Override
            public HandlerResult<Response<SearchResult>> process(Connection conn, SearchRequest request, Response<SearchResult> response) throws LdapException {
                try {
                    SyncReplClient.this.logger.debug("received {}", response);
                    queue.put(new SyncReplItem(new SyncReplItem.Response(response)));
                }
                catch (Exception e) {
                    SyncReplClient.this.logger.warn("Unable to enqueue response {}", response);
                }
                return new HandlerResult<Response<SearchResult>>(response);
            }
        });
        request.setControls(new SyncRequestControl(this.refreshAndPersist ? SyncRequestControl.Mode.REFRESH_AND_PERSIST : SyncRequestControl.Mode.REFRESH_ONLY, this.syncCookie, true));
        request.setSearchEntryHandlers(new SearchEntryHandler(){

            @Override
            public HandlerResult<SearchEntry> process(Connection conn, SearchRequest request, SearchEntry entry) throws LdapException {
                try {
                    SyncReplClient.this.logger.debug("received {}", (Object)entry);
                    queue.put(new SyncReplItem(new SyncReplItem.Entry(entry)));
                }
                catch (Exception e) {
                    SyncReplClient.this.logger.warn("Unable to enqueue entry {}", (Object)entry);
                }
                return new HandlerResult<Object>(null);
            }
        });
        request.setIntermediateResponseHandlers(new IntermediateResponseHandler(){

            @Override
            public HandlerResult<IntermediateResponse> process(Connection conn, Request request, IntermediateResponse response) throws LdapException {
                if ("1.3.6.1.4.1.4203.1.9.1.4".equals(response.getOID())) {
                    try {
                        SyncReplClient.this.logger.debug("received {}", (Object)response);
                        queue.put(new SyncReplItem((SyncInfoMessage)response));
                    }
                    catch (Exception e) {
                        SyncReplClient.this.logger.warn("Unable to enqueue intermediate response {}", (Object)response);
                    }
                }
                return new HandlerResult<Object>(null);
            }
        });
        search.execute(request);
        return queue;
    }

    public Response<Void> cancel(int messageId) throws LdapException {
        CancelOperation cancel = new CancelOperation(this.connection);
        return cancel.execute(new CancelRequest(messageId));
    }
}

