/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control.util;

import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.control.PagedResultsControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagedResultsClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Connection connection;
    private final int resultSize;

    public PagedResultsClient(Connection conn, int size) {
        this.connection = conn;
        this.resultSize = size;
    }

    public Response<SearchResult> execute(SearchRequest request) throws LdapException {
        SearchOperation search = new SearchOperation(this.connection);
        request.setControls(new PagedResultsControl(this.resultSize, true));
        return search.execute(request);
    }

    public Response<SearchResult> execute(SearchRequest request, Response<SearchResult> response) throws LdapException {
        byte[] cookie = this.getPagedResultsCookie(response);
        if (cookie == null) {
            throw new IllegalArgumentException("Response does not contain a paged results cookie");
        }
        SearchOperation search = new SearchOperation(this.connection);
        request.setControls(new PagedResultsControl(this.resultSize, cookie, true));
        return search.execute(request);
    }

    public boolean hasMore(Response<SearchResult> response) {
        return this.getPagedResultsCookie(response) != null;
    }

    public Response<SearchResult> executeToCompletion(SearchRequest request) throws LdapException {
        Response<SearchResult> response = null;
        SearchResult result = new SearchResult();
        SearchOperation search = new SearchOperation(this.connection);
        byte[] cookie = null;
        do {
            if (response != null && response.getResult() != null) {
                result.addEntries(((SearchResult)response.getResult()).getEntries());
                result.addReferences(((SearchResult)response.getResult()).getReferences());
            }
            request.setControls(new PagedResultsControl(this.resultSize, cookie, true));
        } while ((cookie = this.getPagedResultsCookie(response = search.execute(request))) != null);
        response.getResult().addEntries(result.getEntries());
        response.getResult().addReferences(result.getReferences());
        return response;
    }

    protected byte[] getPagedResultsCookie(Response<SearchResult> response) {
        byte[] cookie = null;
        PagedResultsControl ctl = (PagedResultsControl)response.getControl("1.2.840.113556.1.4.319");
        if (ctl != null && ctl.getCookie() != null && ctl.getCookie().length > 0) {
            cookie = ctl.getCookie();
        }
        return cookie;
    }
}

