/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Operation;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.concurrent.AbstractParallelSearchExecutor;
import org.ldaptive.handler.SearchEntryHandler;
import org.ldaptive.pool.PooledConnectionFactory;

public class ParallelPooledSearchExecutor
extends AbstractParallelSearchExecutor<PooledConnectionFactory> {
    public ParallelPooledSearchExecutor() {
        this(Executors.newCachedThreadPool());
    }

    public ParallelPooledSearchExecutor(ExecutorService es) {
        super(es);
    }

    @Override
    public Collection<Response<SearchResult>> search(PooledConnectionFactory factory, SearchFilter[] filters, String[] attrs, SearchEntryHandler ... handlers) throws LdapException {
        ArrayList<Response<SearchResult>> response = new ArrayList<Response<SearchResult>>(filters.length);
        ExecutorCompletionService<Response<SearchResult>> searches = new ExecutorCompletionService<Response<SearchResult>>(this.getExecutorService());
        for (SearchFilter filter : filters) {
            SearchRequest sr = ParallelPooledSearchExecutor.newSearchRequest(this);
            if (filter != null) {
                sr.setSearchFilter(filter);
            }
            if (attrs != null) {
                sr.setReturnAttributes(attrs);
            }
            if (handlers != null) {
                sr.setSearchEntryHandlers(handlers);
            }
            Connection conn = factory.getConnection();
            SearchOperation op = new SearchOperation(conn);
            op.setOperationResponseHandlers(this.getSearchResponseHandlers());
            searches.submit(ParallelPooledSearchExecutor.createCallable(conn, op, sr));
        }
        for (SearchFilter filter : filters) {
            try {
                response.add((Response<SearchResult>)searches.take().get());
            }
            catch (ExecutionException e) {
                this.logger.debug("ExecutionException thrown, ignoring", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.logger.warn("InterrupedException thrown, ignoring", (Throwable)e);
            }
        }
        return response;
    }

    protected static <Q extends Request, S> Callable<Response<S>> createCallable(final Connection conn, final Operation<Q, S> operation, final Q request) {
        return new Callable<Response<S>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response<S> call() throws LdapException {
                try {
                    conn.open();
                    Response response = operation.execute(request);
                    return response;
                }
                finally {
                    conn.close();
                }
            }
        };
    }
}

