/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.handler.OperationResponseHandler;
import org.ldaptive.handler.SearchEntryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParallelSearchExecutor<T extends ConnectionFactory>
extends SearchRequest {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService service;
    private OperationResponseHandler<SearchRequest, SearchResult>[] searchResponseHandlers;

    public AbstractParallelSearchExecutor(ExecutorService es) {
        if (es == null) {
            throw new NullPointerException("ExecutorService cannot be null");
        }
        this.service = es;
    }

    protected ExecutorService getExecutorService() {
        return this.service;
    }

    public OperationResponseHandler<SearchRequest, SearchResult>[] getSearchResponseHandlers() {
        return this.searchResponseHandlers;
    }

    public void setSearchResponseHandlers(OperationResponseHandler<SearchRequest, SearchResult> ... handlers) {
        this.searchResponseHandlers = handlers;
    }

    public void shutdown() {
        this.service.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.service.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    public Collection<Response<SearchResult>> search(T factory, String ... filters) throws LdapException {
        SearchFilter[] sf = new SearchFilter[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            sf[i] = new SearchFilter(filters[i]);
        }
        return this.search(factory, sf, (String[])null, (SearchEntryHandler[])null);
    }

    public Collection<Response<SearchResult>> search(T factory, SearchFilter[] filters) throws LdapException {
        return this.search(factory, filters, (String[])null, (SearchEntryHandler[])null);
    }

    public Collection<Response<SearchResult>> search(T factory, String[] filters, String ... attrs) throws LdapException {
        SearchFilter[] sf = new SearchFilter[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            sf[i] = new SearchFilter(filters[i]);
        }
        return this.search(factory, sf, attrs, (SearchEntryHandler[])null);
    }

    public Collection<Response<SearchResult>> search(T factory, SearchFilter[] filters, String ... attrs) throws LdapException {
        return this.search(factory, filters, attrs, (SearchEntryHandler[])null);
    }

    public abstract Collection<Response<SearchResult>> search(T var1, SearchFilter[] var2, String[] var3, SearchEntryHandler ... var4) throws LdapException;
}

