/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.cli;

import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.ldaptive.CompareOperation;
import org.ldaptive.CompareRequest;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapUtils;
import org.ldaptive.cli.AbstractCli;
import org.ldaptive.props.ConnectionConfigPropertySource;
import org.ldaptive.props.SslConfigPropertySource;
import org.ldaptive.ssl.SslConfig;

public class CompareOperationCli
extends AbstractCli {
    private static final String OPT_DN = "dn";
    private static final String OPT_ATTR = "attribute";
    private static final String COMMAND_NAME = "ldapcompare";

    public static void main(String[] args) {
        new CompareOperationCli().performAction(args);
    }

    @Override
    protected void initOptions() {
        this.options.addOption(new Option(OPT_DN, true, "entry DN"));
        this.options.addOption(new Option(OPT_ATTR, true, "colon delimited name value pair (attr:value|attr::b64value)"));
        Map<String, String> desc = this.getArgDesc(ConnectionConfig.class, SslConfig.class);
        for (String s : ConnectionConfigPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        for (String s : SslConfigPropertySource.getProperties()) {
            this.options.addOption(new Option(s, true, desc.get(s)));
        }
        super.initOptions();
    }

    @Override
    protected void dispatch(CommandLine line) throws Exception {
        if (line.hasOption("help")) {
            this.printHelp();
        } else {
            String[] attr = line.getOptionValue(OPT_ATTR).split(":", 2);
            LdapAttribute la = attr[1].startsWith(":") ? new LdapAttribute(attr[0], new byte[][]{LdapUtils.base64Decode(attr[1].substring(1))}) : new LdapAttribute(attr[0], attr[1]);
            this.compare(this.initConnectionFactory(line), line.getOptionValue(OPT_DN), la);
        }
    }

    protected void compare(ConnectionFactory cf, String dn, LdapAttribute attr) throws Exception {
        Connection conn = cf.getConnection();
        conn.open();
        CompareOperation op = new CompareOperation(conn);
        System.out.println(op.execute(new CompareRequest(dn, attr)).getResult());
        conn.close();
    }

    @Override
    protected String getCommandName() {
        return COMMAND_NAME;
    }
}

