/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth.ext;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.ext.EDirectoryAccountState;

public class EDirectoryAuthenticationResponseHandler
implements AuthenticationResponseHandler {
    @Override
    public void process(AuthenticationResponse response) {
        EDirectoryAccountState.Error edError;
        LdapEntry entry = response.getLdapEntry();
        LdapAttribute expTime = entry.getAttribute("passwordExpirationTime");
        LdapAttribute loginRemaining = entry.getAttribute("loginGraceRemaining");
        Calendar exp = null;
        if (expTime != null) {
            exp = Calendar.getInstance();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                exp.setTime(formatter.parse(expTime.getStringValue()));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Expiration time format error", e);
            }
        }
        if (exp != null || loginRemaining != null) {
            response.setAccountState(new EDirectoryAccountState(exp, loginRemaining != null ? Integer.parseInt(loginRemaining.getStringValue()) : 0));
        }
        if (response.getAccountState() == null && response.getMessage() != null && (edError = EDirectoryAccountState.Error.parse(response.getMessage())) != null) {
            response.setAccountState(new EDirectoryAccountState(edError));
        }
    }
}

