/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionFactoryManager;
import org.ldaptive.LdapException;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResult;
import org.ldaptive.auth.AbstractSearchEntryResolver;
import org.ldaptive.auth.AuthenticationCriteria;

public class SearchEntryResolver
extends AbstractSearchEntryResolver
implements ConnectionFactoryManager {
    private ConnectionFactory factory;

    public SearchEntryResolver() {
    }

    public SearchEntryResolver(String ... attrs) {
        this.setReturnAttributes(attrs);
    }

    public SearchEntryResolver(ConnectionFactory cf) {
        this.setConnectionFactory(cf);
    }

    public SearchEntryResolver(ConnectionFactory cf, String ... attrs) {
        this.setConnectionFactory(cf);
        this.setReturnAttributes(attrs);
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    @Override
    public void setConnectionFactory(ConnectionFactory cf) {
        this.factory = cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchResult performLdapSearch(Connection conn, AuthenticationCriteria ac) throws LdapException {
        if (this.factory == null) {
            SearchOperation search = new SearchOperation(conn);
            return (SearchResult)search.execute(this.createSearchRequest(ac, this.getReturnAttributes())).getResult();
        }
        Connection factoryConn = null;
        try {
            factoryConn = this.factory.getConnection();
            factoryConn.open();
            SearchOperation search = new SearchOperation(factoryConn);
            SearchResult searchResult = (SearchResult)search.execute(this.createSearchRequest(ac, this.getReturnAttributes())).getResult();
            return searchResult;
        }
        finally {
            if (factoryConn != null) {
                factoryConn.close();
            }
        }
    }

    public String toString() {
        return String.format("[%s@%d::factory=%s, returnAttributes=%s]", this.getClass().getName(), this.hashCode(), this.factory, Arrays.toString(this.getReturnAttributes()));
    }
}

