/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import java.util.Iterator;
import org.ldaptive.Connection;
import org.ldaptive.DerefAliases;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.SearchScope;
import org.ldaptive.auth.DnResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchDnResolver
implements DnResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String baseDn = "";
    private String userFilter;
    private Object[] userFilterParameters;
    private boolean allowMultipleDns;
    private boolean subtreeSearch;
    private DerefAliases derefAliases;
    private boolean followReferrals;

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String dn) {
        this.logger.trace("setting baseDn: {}", (Object)dn);
        this.baseDn = dn;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String filter) {
        this.logger.trace("setting userFilter: {}", (Object)filter);
        this.userFilter = filter;
    }

    public Object[] getUserFilterParameters() {
        return this.userFilterParameters;
    }

    public void setUserFilterParameters(Object[] filterParams) {
        this.logger.trace("setting userFilterParameters: {}", (Object)Arrays.toString(filterParams));
        this.userFilterParameters = filterParams;
    }

    public boolean getAllowMultipleDns() {
        return this.allowMultipleDns;
    }

    public void setAllowMultipleDns(boolean b) {
        this.logger.trace("setting allowMultipleDns: {}", (Object)b);
        this.allowMultipleDns = b;
    }

    public boolean getSubtreeSearch() {
        return this.subtreeSearch;
    }

    public void setSubtreeSearch(boolean b) {
        this.logger.trace("setting subtreeSearch: {}", (Object)b);
        this.subtreeSearch = b;
    }

    public DerefAliases getDerefAliases() {
        return this.derefAliases;
    }

    public void setDerefAliases(DerefAliases da) {
        this.logger.trace("setting derefAliases: {}", (Object)da);
        this.derefAliases = da;
    }

    public boolean getFollowReferrals() {
        return this.followReferrals;
    }

    public void setFollowReferrals(boolean b) {
        this.logger.trace("setting followReferrals: {}", (Object)b);
        this.followReferrals = b;
    }

    @Override
    public String resolve(String user) throws LdapException {
        this.logger.debug("resolve user={}", (Object)user);
        String dn = null;
        if (user != null && !"".equals(user)) {
            SearchFilter filter = this.createSearchFilter(user);
            if (filter.getFilter() != null) {
                SearchResult result = this.performLdapSearch(filter);
                Iterator<LdapEntry> answer = result.getEntries().iterator();
                if (answer != null && answer.hasNext()) {
                    dn = this.resolveDn(answer.next());
                    if (answer.hasNext()) {
                        this.logger.debug("multiple results found for user={} using filter={}", (Object)user, (Object)filter);
                        if (!this.allowMultipleDns) {
                            throw new LdapException("Found more than (1) DN for: " + user);
                        }
                    }
                } else {
                    this.logger.info("search for user={} failed using filter={}", (Object)user, (Object)filter);
                }
            } else {
                this.logger.error("DN search filter not found, no search performed");
            }
        } else {
            this.logger.warn("DN resolution cannot occur, user input was empty or null");
        }
        this.logger.debug("resolved dn={} for user={}", dn, (Object)user);
        return dn;
    }

    protected String resolveDn(LdapEntry entry) {
        return entry.getDn();
    }

    protected SearchFilter createSearchFilter(String user) {
        SearchFilter filter = new SearchFilter();
        if (this.userFilter != null) {
            this.logger.debug("searching for DN using userFilter");
            filter.setFilter(this.userFilter);
            if (this.userFilterParameters != null) {
                filter.setParameters(this.userFilterParameters);
            }
            filter.setParameter("user", (Object)user);
        } else {
            this.logger.error("Invalid userFilter, cannot be null or empty.");
        }
        return filter;
    }

    protected SearchRequest createSearchRequest(SearchFilter filter) {
        SearchRequest request = new SearchRequest();
        request.setBaseDn(this.baseDn);
        request.setSearchFilter(filter);
        request.setReturnAttributes(new String[0]);
        if (this.subtreeSearch) {
            request.setSearchScope(SearchScope.SUBTREE);
        } else {
            request.setSearchScope(SearchScope.ONELEVEL);
        }
        request.setDerefAliases(this.derefAliases);
        request.setFollowReferrals(this.followReferrals);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResult performLdapSearch(SearchFilter filter) throws LdapException {
        SearchRequest request = this.createSearchRequest(filter);
        Connection conn = null;
        try {
            conn = this.getConnection();
            SearchOperation op = new SearchOperation(conn);
            SearchResult searchResult = (SearchResult)op.execute(request).getResult();
            return searchResult;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    protected abstract Connection getConnection() throws LdapException;
}

