/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import org.ldaptive.AbstractConfig;
import org.ldaptive.Credential;
import org.ldaptive.control.RequestControl;
import org.ldaptive.sasl.SaslConfig;
import org.ldaptive.ssl.SslConfig;

public class ConnectionConfig
extends AbstractConfig {
    private String ldapUrl;
    private long connectTimeout = -1L;
    private long responseTimeout = -1L;
    private String bindDn;
    private Credential bindCredential;
    private SaslConfig bindSaslConfig;
    private RequestControl[] bindControls;
    private SslConfig sslConfig;
    private boolean useSSL;
    private boolean useStartTLS;

    public ConnectionConfig() {
    }

    public ConnectionConfig(String url) {
        this.setLdapUrl(url);
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String url) {
        this.checkImmutable();
        this.checkStringInput(url, true);
        this.logger.trace("setting ldapUrl: {}", (Object)url);
        this.ldapUrl = url;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long time) {
        this.checkImmutable();
        this.logger.trace("setting connectTimeout: {}", (Object)time);
        this.connectTimeout = time;
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(long time) {
        this.checkImmutable();
        this.logger.trace("setting responseTimeout: {}", (Object)time);
        this.responseTimeout = time;
    }

    public String getBindDn() {
        return this.bindDn;
    }

    public void setBindDn(String dn) {
        this.checkImmutable();
        this.checkStringInput(dn, true);
        this.logger.trace("setting bindDn: {}", (Object)dn);
        this.bindDn = dn;
    }

    public Credential getBindCredential() {
        return this.bindCredential;
    }

    public void setBindCredential(Credential credential) {
        this.checkImmutable();
        this.logger.trace("setting bindCredential: <suppressed>");
        this.bindCredential = credential;
    }

    public SaslConfig getBindSaslConfig() {
        return this.bindSaslConfig;
    }

    public void setBindSaslConfig(SaslConfig config) {
        this.checkImmutable();
        this.logger.trace("setting bindSaslConfig: {}", (Object)config);
        this.bindSaslConfig = config;
    }

    public RequestControl[] getBindControls() {
        return this.bindControls;
    }

    public void setBindControls(RequestControl ... c) {
        this.checkImmutable();
        this.logger.trace("setting bindControls: {}", (Object)Arrays.toString(c));
        this.bindControls = c;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(SslConfig config) {
        this.checkImmutable();
        this.logger.trace("setting sslConfig: {}", (Object)config);
        this.sslConfig = config;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting useSSL: {}", (Object)b);
        this.useSSL = b;
    }

    public boolean getUseStartTLS() {
        return this.useStartTLS;
    }

    public void setUseStartTLS(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting useStartTLS: {}", (Object)b);
        this.useStartTLS = b;
    }

    public String toString() {
        return String.format("[%s@%d::ldapUrl=%s, connectTimeout=%s, responseTimeout=%s, bindDn=%s, bindSaslConfig=%s, bindControls=%s, sslConfig=%s, useSSL=%s, useStartTLS=%s]", this.getClass().getName(), this.hashCode(), this.ldapUrl, this.connectTimeout, this.responseTimeout, this.bindDn, this.bindSaslConfig, Arrays.toString(this.bindControls), this.sslConfig, this.useSSL, this.useStartTLS);
    }
}

