/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.x509.dn.impl;

import java.util.Map;
import java.util.Set;
import net.shibboleth.idp.attribute.Attribute;
import net.shibboleth.idp.attribute.AttributeContext;
import net.shibboleth.idp.attribute.AttributeValue;
import org.glite.sts.STSException;
import org.glite.sts.x509.dn.DNBuilder;
import org.glite.sts.x509.dn.DNBuildingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternDNBuilder
implements DNBuilder {
    private static Logger log = LoggerFactory.getLogger(PatternDNBuilder.class);
    private String pattern = null;

    public PatternDNBuilder(String pattern) throws STSException {
        if (pattern == null) {
            log.error("Pattern cannot be null!");
            throw new STSException("Pattern cannot be null");
        }
        log.info("Initializing the PatternDNBuilder with the pattern {}", (Object)pattern);
        this.pattern = pattern;
    }

    @Override
    public String createDN(AttributeContext attributeContext) throws DNBuildingException {
        if (attributeContext == null) {
            log.error("AttributeContext cannot be null!");
            throw new DNBuildingException("AttributeContext cannot be null!");
        }
        String dn = this.pattern;
        Map<String, Attribute> attributes = attributeContext.getAttributes();
        Set<String> attributeNames = attributes.keySet();
        for (String name : attributeNames) {
            String placeholder = "${" + name + "}";
            if (this.pattern.indexOf(placeholder) == -1) continue;
            Set<AttributeValue> value = attributes.get(name).getValues();
            if (value.size() != 1) {
                log.error("Attribute {} is multi-valued, size: {}", (Object)name, (Object)value.size());
                throw new DNBuildingException("Ambiguous muli-valued attribute: " + name + ", " + value.size() + " values.");
            }
            String valueStr = (String)value.iterator().next().getValue();
            String replace = "\\$\\{" + name + "\\}";
            log.debug("replace regex {} by {}", (Object)replace, (Object)valueStr);
            dn = dn.replaceAll(replace, valueStr);
        }
        if (dn.indexOf("${") != -1) {
            log.error("DN still contains not substitued placeholders: {}", (Object)dn);
            throw new DNBuildingException("Missing or wrong Shibboleth attributes: DN still contains placeholders: " + dn);
        }
        log.debug("Constructed the following DN: {}", (Object)dn);
        return dn;
    }
}

