/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.x509.caclient.impl;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.glite.sts.ta.x509.X509TokenGenerationContext;
import org.glite.sts.x509.caclient.CAClientException;
import org.glite.sts.x509.caclient.CAConnection;
import org.glite.sts.x509.caclient.CARequest;
import org.glite.sts.x509.caclient.impl.CMPClient;
import org.glite.sts.x509.caclient.impl.CMPRequest;
import org.glite.sts.x509.caclient.impl.CMPResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMPConnection
implements CAConnection {
    private static Logger log = LoggerFactory.getLogger(CMPConnection.class);
    private CMPClient cmpClient;

    protected CMPConnection(CMPClient client) {
        this.cmpClient = client;
    }

    @Override
    public void createRequest(X509TokenGenerationContext context) throws CAClientException {
        CMPRequest cmpRequest = new CMPRequest(context, this.cmpClient.getCmpProperties());
        context.setCaRequest(cmpRequest);
    }

    @Override
    public synchronized void submitRequest(X509TokenGenerationContext context) throws CAClientException {
        CARequest caRequest = context.getCaRequest();
        if (caRequest == null) {
            throw new CAClientException("No CARequest object found from the context!");
        }
        byte[] requestBytes = caRequest.getDEREncoded();
        ByteArrayEntity entity = new ByteArrayEntity(requestBytes);
        HttpPost cmpServerPost = new HttpPost(this.cmpClient.getServerUrl());
        cmpServerPost.setEntity((HttpEntity)entity);
        HttpClient httpClient = this.cmpClient.getHttpClient();
        HttpResponse postResponse = null;
        try {
            log.debug("Sending the request to the online CA...");
            postResponse = httpClient.execute((HttpUriRequest)cmpServerPost);
            log.debug("The response from the online CA: {}", (Object)postResponse);
        }
        catch (IOException e) {
            log.error("IO error while sending the request to the online CA.", (Throwable)e);
            throw new CAClientException(e);
        }
        CMPResponse caResponse = new CMPResponse(postResponse);
        try {
            EntityUtils.consume((HttpEntity)postResponse.getEntity());
        }
        catch (IOException e) {
            log.error("Could not consume the response from the online CA", (Throwable)e);
            throw new CAClientException(e);
        }
        context.setCaResponse(caResponse);
    }
}

