/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.x509.caclient.impl;

import com.novosec.pkix.asn1.cmp.CMPObjectIdentifiers;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.client.HttpClient;
import org.glite.sts.STSException;
import org.glite.sts.config.ServerConfiguration;
import org.glite.sts.util.HttpClientBuilder;
import org.glite.sts.x509.caclient.CAClient;
import org.glite.sts.x509.caclient.CAClientException;
import org.glite.sts.x509.caclient.CAConnection;
import org.glite.sts.x509.caclient.impl.CMPConnection;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMPClient
implements CAClient {
    public static final String SERVER_URL_IDENTIFIER = "serverUrl";
    public static final String CA_DN_IDENTIFIER = "caDn";
    public static final String SENDER_DN_IDENTIFIER = "senderDn";
    public static final String RECIPIENT_DN_IDENTIFIER = "recipientDn";
    public static final String SENDER_KID_IDENTIFIER = "senderKid";
    public static final String SHARED_SECRET_IDENTIFIER = "sharedSecret";
    public static final String OWF_ALG_ID_IDENTIFIER = "owfAlgId";
    public static final String ITERATION_COUNT_IDENTIFIER = "iterCount";
    public static final String MAC_ALG_ID_IDENTIFIER = "macAlgId";
    public static final String SALT_STRING_IDENTIFIER = "saltString";
    public static final String PROTECTION_ALG_ID_IDENTIFIER = "protectionAlgId";
    public static final String DEFAULT_OWF_ALGID = "1.3.14.3.2.26";
    public static final String DEFAULT_ITERATION_COUNT = "1";
    public static final String DEFAULT_MAC_ALGID = "1.3.6.1.5.5.8.1.2";
    public static final String DEFAULT_PROTECTION_ALGID = CMPObjectIdentifiers.passwordBasedMac.toString();
    private static Logger log = LoggerFactory.getLogger(CMPClient.class);
    private HttpClient httpClient;
    private Properties cmpProperties;
    private String serverUrl;

    public CMPClient(ServerConfiguration serverConfiguration) throws STSException, CAClientException {
        this(null, null, serverConfiguration);
    }

    public CMPClient(X509CertChainValidator chainValidator, ServerConfiguration serverConfiguration) throws STSException, CAClientException {
        this(null, chainValidator, serverConfiguration);
    }

    public CMPClient(X509Credential credential, X509CertChainValidator chainValidator, ServerConfiguration serverConfiguration) throws STSException, CAClientException {
        Profile.Section iniSection = serverConfiguration.getConfigurationSection("CAClient");
        this.serverUrl = (String)Constraint.isNotNull((Object)iniSection.get((Object)SERVER_URL_IDENTIFIER), (String)"The serverUrl cannot be null!");
        this.setCmpProperties(iniSection);
        this.httpClient = this.createHttpClient(credential, chainValidator);
    }

    public void setCmpProperties(Profile.Section iniSection) throws CAClientException {
        this.cmpProperties = new Properties();
        this.generateCmpProperties(iniSection);
    }

    @Override
    public CAConnection getConnection() throws CAClientException {
        return new CMPConnection(this);
    }

    private void generateCmpProperties(Profile.Section iniSection) throws CAClientException {
        this.addCmpConfigurationVariable(iniSection, CA_DN_IDENTIFIER, null);
        this.addCmpConfigurationVariable(iniSection, SENDER_DN_IDENTIFIER, null);
        this.addCmpConfigurationVariable(iniSection, RECIPIENT_DN_IDENTIFIER, null);
        this.addCmpConfigurationVariable(iniSection, SENDER_KID_IDENTIFIER, null);
        this.addCmpConfigurationVariable(iniSection, SHARED_SECRET_IDENTIFIER, null);
        this.addCmpConfigurationVariable(iniSection, OWF_ALG_ID_IDENTIFIER, DEFAULT_OWF_ALGID);
        this.addCmpConfigurationVariable(iniSection, ITERATION_COUNT_IDENTIFIER, DEFAULT_ITERATION_COUNT);
        this.addCmpConfigurationVariable(iniSection, MAC_ALG_ID_IDENTIFIER, DEFAULT_MAC_ALGID);
        this.addCmpConfigurationVariable(iniSection, SALT_STRING_IDENTIFIER, "");
        this.addCmpConfigurationVariable(iniSection, PROTECTION_ALG_ID_IDENTIFIER, DEFAULT_PROTECTION_ALGID);
    }

    private void addCmpConfigurationVariable(Profile.Section iniSection, String variable, String defaultValue) throws CAClientException {
        String str = (String)iniSection.get((Object)variable);
        if (str == null || str.equals("")) {
            if (defaultValue == null) {
                throw new CAClientException(variable + " is a required variable!");
            }
            log.info("CAClient." + variable + "='" + defaultValue + "' (was null, using default)");
            this.cmpProperties.setProperty(variable, defaultValue);
        } else {
            this.cmpProperties.setProperty(variable, str);
            log.info(variable + "=" + str);
        }
    }

    private HttpClient createHttpClient(X509Credential credential, X509CertChainValidator chainValidator) throws CAClientException {
        HttpClientBuilder httpBuilder = new HttpClientBuilder(this.serverUrl, credential, chainValidator);
        HttpClient httpClient = null;
        try {
            httpClient = httpBuilder.buildClient();
        }
        catch (IOException e) {
            log.error("Could not build an HTTP client", (Throwable)e);
            throw new CAClientException(e);
        }
        catch (GeneralSecurityException e) {
            log.error("Security error while building an HTTP client", (Throwable)e);
            throw new CAClientException(e);
        }
        return httpClient;
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
        this.httpClient = null;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected Properties getCmpProperties() {
        return this.cmpProperties;
    }

    protected String getServerUrl() {
        return this.serverUrl;
    }
}

