/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.x509;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.glite.sts.STSException;
import org.glite.sts.x509.CertificateKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSACertificateKeys
implements CertificateKeys {
    private static Logger log = LoggerFactory.getLogger(RSACertificateKeys.class);
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public RSACertificateKeys(int keysize) throws STSException {
        this(keysize, "BC");
    }

    public RSACertificateKeys(int keysize, String provider) throws STSException {
        KeyPairGenerator generator = null;
        log.debug("Initializing a keypair with keysize {}", (Object)keysize);
        try {
            generator = KeyPairGenerator.getInstance("RSA", provider);
            generator.initialize(keysize);
        }
        catch (NoSuchAlgorithmException e) {
            throw new STSException("Invalid key algorithm", e);
        }
        catch (NoSuchProviderException e2) {
            throw new STSException("Provider " + provider + " not found, is it installed?", e2);
        }
        KeyPair keyPair = generator.generateKeyPair();
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
    }

    public RSACertificateKeys(PublicKey publicKey, PrivateKey privateKey) throws STSException {
        if (publicKey == null || !publicKey.getAlgorithm().equals("RSA") || privateKey != null && !privateKey.getAlgorithm().equals("RSA")) {
            throw new STSException("Invalid key algorithm!");
        }
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public RSACertificateKeys(PublicKey publicKey) throws STSException {
        this(publicKey, null);
    }

    @Override
    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

