/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.voms.xmlobject.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import org.glite.sts.voms.xmlobject.GridProxyRequest;
import org.glite.sts.voms.xmlobject.VomsAttributeCertificates;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class GridProxyRequestUnmarshaller
extends AbstractXMLObjectUnmarshaller {
    private final Logger log = LoggerFactory.getLogger(GridProxyRequestUnmarshaller.class);

    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
        this.log.debug("Processing attributes for GridProxyRequest");
        GridProxyRequest proxyRequest = (GridProxyRequest)xmlObject;
        if (attribute.getLocalName().equals("lifetime")) {
            this.log.debug("Lifetime {} found, setting it for the value.", (Object)attribute.getValue());
            proxyRequest.setLifetime(new Integer(attribute.getValue()));
        } else if (attribute.getLocalName().equals("proxyType")) {
            this.log.debug("Proxy type {} found, setting it for the value.", (Object)attribute.getValue());
            proxyRequest.setProxyType(new Integer(attribute.getValue()));
        } else if (attribute.getLocalName().equals("delegationType")) {
            this.log.debug("Delegation type {} found, setting it for the value.", (Object)attribute.getValue());
            proxyRequest.setDelegationType(new Integer(attribute.getValue()));
        } else if (attribute.getLocalName().equals("policyType")) {
            this.log.debug("Policy type {} found, setting it for the value.", (Object)attribute.getValue());
            proxyRequest.setPolicyType(new Integer(attribute.getValue()));
        } else {
            QName attribQName = QNameSupport.getNodeQName((Node)attribute);
            if (attribute.isId()) {
                proxyRequest.getUnknownAttributes().registerID(attribQName);
            }
            proxyRequest.getUnknownAttributes().put(attribQName, attribute.getValue());
        }
    }

    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
        this.log.debug("Processing child element for GridProxyRequest");
        GridProxyRequest proxyRequest = (GridProxyRequest)parentXMLObject;
        if (childXMLObject instanceof VomsAttributeCertificates) {
            this.log.debug("Setting VomsAttributeCertificates");
            proxyRequest.setVomsAttributeCertificates((VomsAttributeCertificates)childXMLObject);
        } else {
            super.processChildElement(parentXMLObject, childXMLObject);
        }
    }
}

