/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.util;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpClientBuilder.class);
    private URL serverUrl;
    private boolean connectionPooling;
    private int connectionsMaxTotal;
    private int connectionsMaxPerRoute;
    private X509Credential credential;
    private X509CertChainValidator chainValidator;

    public HttpClientBuilder(String url, X509Credential credential, X509CertChainValidator chainValidator) {
        this.setUrl(url);
        this.credential = credential;
        this.chainValidator = chainValidator;
    }

    protected void setUrl(String url) {
        log.debug("Setting service URL for {}", (Object)url);
        try {
            this.serverUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            log.error("The given URL {} is not valid", (Object)url);
        }
    }

    public HttpClient buildClient() throws IOException, GeneralSecurityException {
        DefaultHttpClient client = new DefaultHttpClient(this.buildConnectionManager());
        client.addRequestInterceptor((HttpRequestInterceptor)new RequestAcceptEncoding());
        client.addResponseInterceptor((HttpResponseInterceptor)new ResponseContentEncoding());
        return client;
    }

    private ClientConnectionManager buildConnectionManager() throws IOException, GeneralSecurityException {
        SchemeRegistry registry = this.buildSchemeRegistry();
        if (!this.connectionPooling) {
            return new BasicClientConnectionManager(registry);
        }
        PoolingClientConnectionManager manager = new PoolingClientConnectionManager(registry);
        manager.setDefaultMaxPerRoute(this.connectionsMaxPerRoute);
        manager.setMaxTotal(this.connectionsMaxTotal);
        return manager;
    }

    private SchemeRegistry buildSchemeRegistry() throws IOException, GeneralSecurityException {
        SchemeRegistry registry = new SchemeRegistry();
        String protocol = this.serverUrl.getProtocol();
        log.debug("Trying to register protocol {}", (Object)protocol);
        if (protocol.equals("http")) {
            registry.register(new Scheme("http", this.serverUrl.getPort(), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        } else if (protocol.equals("https")) {
            SSLSocketFactory sslSF = new SSLSocketFactory(SocketFactoryCreator.getSocketFactory((X509Credential)this.credential, (X509CertChainValidator)this.chainValidator), SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            registry.register(new Scheme("https", this.serverUrl.getPort(), (SchemeSocketFactory)sslSF));
            log.info("Registered the scheme 'https' for port {}", (Object)this.serverUrl.getPort());
        } else {
            log.error("Invalid protocol ({}), HTTP client could not be initialized!", (Object)protocol);
        }
        return registry;
    }
}

