/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.ta.x509;

import com.google.common.base.Function;
import org.glite.sts.ta.TokenGenerationContext;
import org.glite.sts.ta.TokenGenerationException;
import org.glite.sts.ta.TokenGenerator;
import org.glite.sts.ta.x509.X509TokenGenerationContext;
import org.glite.sts.x509.caclient.CAClient;
import org.glite.sts.x509.caclient.CAClientException;
import org.glite.sts.x509.caclient.CAConnection;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509TokenGenerator
implements TokenGenerator {
    private static Logger log = LoggerFactory.getLogger(X509TokenGenerator.class);
    private Function<TokenGenerationContext, X509TokenGenerationContext> x509TokenGenerationContextLookupStrategy;
    private CAClient caClient;

    public X509TokenGenerator(CAClient caClient) {
        this.caClient = caClient;
        this.x509TokenGenerationContextLookupStrategy = new ChildContextLookup(X509TokenGenerationContext.class, false);
    }

    @Override
    public void issueToken(TokenGenerationContext ctx) throws TokenGenerationException {
        X509TokenGenerationContext x509ctx = (X509TokenGenerationContext)((Object)this.x509TokenGenerationContextLookupStrategy.apply((Object)ctx));
        CAConnection caConnection = null;
        try {
            caConnection = this.caClient.getConnection();
            caConnection.createRequest(x509ctx);
            caConnection.submitRequest(x509ctx);
        }
        catch (CAClientException e) {
            log.error("Error while connecting the remote CA!", (Throwable)e);
            throw new TokenGenerationException(e);
        }
    }
}

