/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.standalone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.Servlet;
import org.glite.sts.standalone.JettyRunThread;
import org.glite.sts.standalone.JettyShutdownCommand;
import org.glite.sts.standalone.ShutdownServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.BlockingChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class ShutdownAndStatusService {
    public static void startShutdownAndStatusService(int shutdownPort, List<Runnable> shutdownCommands) {
        Server shutdownService = new Server();
        shutdownService.setSendServerVersion(false);
        shutdownService.setSendDateHeader(false);
        Thread shutdownCommandThread = ShutdownAndStatusService.buildServiceShutdownThread(shutdownService, shutdownCommands);
        BlockingChannelConnector connector = new BlockingChannelConnector();
        connector.setHost("localhost");
        connector.setPort(shutdownPort);
        shutdownService.setConnectors(new Connector[]{connector});
        Context servletContext = new Context((HandlerContainer)shutdownService, "/", false, false);
        servletContext.setDisplayName("Shutdown Controller");
        ServletHolder shutdownServlet = new ServletHolder((Servlet)new ShutdownServlet(shutdownCommandThread));
        servletContext.addServlet(shutdownServlet, "/shutdown");
        JettyRunThread shutdownServiceRunThread = new JettyRunThread(shutdownService);
        shutdownServiceRunThread.start();
    }

    private static Thread buildServiceShutdownThread(Server shutdownService, List<Runnable> commands) {
        List<JettyShutdownCommand> shutdownCommands;
        JettyShutdownCommand shutdownShutdownServiceCommand = new JettyShutdownCommand(shutdownService);
        if (commands == null || commands.isEmpty()) {
            shutdownCommands = Collections.singletonList(shutdownShutdownServiceCommand);
        } else {
            shutdownCommands = new ArrayList<Runnable>(commands);
            shutdownCommands.add(shutdownShutdownServiceCommand);
        }
        Thread shutdownCommandThread = new Thread(){

            @Override
            public void run() {
                for (Runnable shutdownCommand : shutdownCommands) {
                    shutdownCommand.run();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(shutdownCommandThread));
        return shutdownCommandThread;
    }
}

