/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.standalone;

import org.mortbay.jetty.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyShutdownCommand
implements Runnable {
    private Logger log = LoggerFactory.getLogger(JettyShutdownCommand.class);
    private Server httpServer;

    public JettyShutdownCommand(Server targetServer) {
        this.log.debug("Constructing a new shutdown command with {}", (Object)targetServer.toString());
        this.httpServer = targetServer;
    }

    @Override
    public void run() {
        if (this.httpServer.isRunning()) {
            this.log.debug("The server {} is running, now trying to stop it", (Object)this.httpServer.toString());
            try {
                this.httpServer.stop();
            }
            catch (Exception e) {
                this.log.error("Unable to shutdown HTTP server", (Throwable)e);
                System.exit(1);
            }
        } else {
            this.log.debug("The server is not running, nothing left to do.");
        }
    }
}

