/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.saml.idstore;

import net.shibboleth.utilities.java.support.logic.Constraint;
import org.glite.sts.saml.idstore.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthnRequestIdManager {
    private static final Logger log = LoggerFactory.getLogger(AuthnRequestIdManager.class);
    private StorageService idStorageService;
    private long idLifetime;

    public AuthnRequestIdManager(StorageService storageService, long lifetime) {
        this.idStorageService = (StorageService)Constraint.isNotNull((Object)storageService, (String)"The storage service cannot be null!");
        this.idLifetime = lifetime;
    }

    public void storeAuthnRequestId(String id) {
        log.debug("Storing authentication request with id {} for {} millis", (Object)id, (Object)this.idLifetime);
        this.idStorageService.put(id, this.idLifetime);
    }

    public boolean isAuthnRequestIdValid(String id) {
        if (this.idStorageService.exists(id)) {
            log.debug("Removing authentication request {} from the storage", (Object)id);
            this.idStorageService.remove(id);
            return true;
        }
        log.info("No authentication request {} found from the storage", (Object)id);
        return false;
    }
}

