/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.saml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import net.shibboleth.idp.service.AbstractReloadableService;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.IDPEntry;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TrustedIdpMetadataService
extends AbstractReloadableService {
    private final Logger log = LoggerFactory.getLogger(TrustedIdpMetadataService.class);
    public static final String METADATA_SCHEMA_FILE = "saml-schema-metadata-2.0.xsd";
    private IDPList idpList;
    private Map<String, Credential> credentials;
    private ParserPool parserPool;

    public TrustedIdpMetadataService(String metadataFolder, ParserPool pool, Timer timer, long frequency) {
        this.parserPool = (ParserPool)Constraint.isNotNull((Object)pool, (String)"Parser pool can not be null");
        this.credentials = new HashMap<String, Credential>();
        this.idpList = this.buildIDPListObject();
        super.setId(this.getClass().getName());
        super.setReloadCheckDelay(frequency);
        super.setReloadTaskTimer(timer);
        this.parseMetadataFolder(metadataFolder);
    }

    public IDPList getTrustedIdpList() {
        return this.idpList;
    }

    public Credential getCredential(String entityId) {
        return this.credentials.get(entityId);
    }

    private void parseMetadataFolder(String metadataFolder) {
        File folder = new File(metadataFolder);
        String[] metadataFiles = folder.list();
        if (metadataFiles == null) {
            this.log.warn("No files found from the folder {}, no trusted Identity Providers.", (Object)metadataFolder);
        } else {
            for (String filename : metadataFiles) {
                filename = metadataFolder + "/" + filename;
                this.log.debug("Extracting entry from {}", (Object)filename);
                this.extractEntry(filename);
            }
        }
    }

    protected IDPList buildIDPListObject() {
        SAMLObjectBuilder idpListBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(IDPList.DEFAULT_ELEMENT_NAME);
        return (IDPList)idpListBuilder.buildObject();
    }

    protected IDPEntry buildIDPEntryObject() {
        SAMLObjectBuilder idpEntryBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(IDPEntry.DEFAULT_ELEMENT_NAME);
        return (IDPEntry)idpEntryBuilder.buildObject();
    }

    public void extractEntry(String idpMetadataFile) {
        EntityDescriptor ed = this.parseMetadata(idpMetadataFile);
        if (ed == null) {
            this.log.warn("File {} did not contain any metadata", (Object)idpMetadataFile);
            return;
        }
        String entityId = ed.getEntityID();
        IDPEntry entry = this.buildIDPEntryObject();
        IDPSSODescriptor ssoDescriptor = ed.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        java.security.cert.X509Certificate certificate = this.extractSigningCertificate(ssoDescriptor);
        if (certificate != null) {
            this.log.debug("Added a credential to {}", (Object)entityId);
            this.credentials.put(entityId, (Credential)new BasicX509Credential(certificate));
        } else {
            this.log.debug("Could not find a credential for {}", (Object)entityId);
        }
        List list = ssoDescriptor.getSingleSignOnServices();
        for (SingleSignOnService singleSignOnService : list) {
            if (!singleSignOnService.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) continue;
            entry.setProviderID(entityId);
            entry.setLoc(singleSignOnService.getLocation());
            entry.setName("ECP");
            this.idpList.getIDPEntrys().add(entry);
            this.log.info("Added an IdP {} from file {}", (Object)entry.getProviderID(), (Object)idpMetadataFile);
        }
    }

    protected java.security.cert.X509Certificate extractSigningCertificate(IDPSSODescriptor ssoDescriptor) {
        try {
            List certificates;
            KeyInfo keyInfo;
            List x509datas;
            List keyDescriptors = ssoDescriptor.getKeyDescriptors();
            if (keyDescriptors != null && keyDescriptors.size() > 0 && (x509datas = (keyInfo = ((KeyDescriptor)keyDescriptors.get(0)).getKeyInfo()).getX509Datas()) != null && x509datas.size() > 0 && (certificates = ((X509Data)x509datas.get(0)).getX509Certificates()) != null && certificates.size() > 0) {
                return X509Support.decodeCertificate((String)((X509Certificate)certificates.get(0)).getValue());
            }
        }
        catch (CertificateException e) {
            this.log.debug("Could not extract a certificate from the metadata", (Throwable)e);
        }
        return null;
    }

    public EntityDescriptor parseMetadata(String idpMetadataFile) {
        Element element;
        FileInputStream fileInput;
        try {
            fileInput = new FileInputStream(idpMetadataFile);
        }
        catch (FileNotFoundException e2) {
            return null;
        }
        try {
            Document doc = this.parserPool.parse((InputStream)fileInput);
            if (doc == null) {
                return null;
            }
            element = doc.getDocumentElement();
        }
        catch (XMLParserException e1) {
            this.log.debug("Could not parse the file {}", (Object)fileInput, (Object)e1);
            return null;
        }
        Unmarshaller unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        try {
            return (EntityDescriptor)unmarshaller.unmarshall(element);
        }
        catch (UnmarshallingException e) {
            this.log.debug("Could not unmarshall the element from {}", (Object)idpMetadataFile);
            return null;
        }
    }

    @Override
    protected boolean shouldReload() {
        return false;
    }
}

