/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile.soap.xmlobject;

import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import org.glite.sts.profile.soap.xmlobject.Request;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

@ThreadSafe
public class RequestUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    private final Logger log = LoggerFactory.getLogger(RequestUnmarshaller.class);

    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
        this.log.debug("Processing attributes for Request");
        Request request = (Request)xmlObject;
        QName attrName = QNameSupport.getNodeQName((Node)attribute);
        if (attribute.getLocalName().equals("messageID")) {
            this.log.debug("MessageID {} found, setting it for the value.", (Object)attribute.getValue());
            request.setMessageID(attribute.getValue());
        } else if (attribute.getLocalName().equals("responseConsumerURL")) {
            this.log.debug("ResponseConsumerURL {} found, setting it for the value.", (Object)attribute.getValue());
            request.setResponseConsumerURL(attribute.getValue());
        } else if (attribute.getLocalName().equals("service")) {
            this.log.debug("Service {} found, setting it for the value.", (Object)attribute.getValue());
            request.setService(attribute.getValue());
        } else if (Request.SOAP11_MUST_UNDERSTAND_ATTR_NAME.equals(attrName)) {
            this.log.debug("SOAP mustUnderstand {} found, setting it for the value.", (Object)attribute.getValue());
            request.setSOAP11MustUnderstand(XSBooleanValue.valueOf((String)attribute.getValue()));
        } else if (Request.SOAP11_ACTOR_ATTR_NAME.equals(attrName)) {
            this.log.debug("SOAP actor {} found, setting it for the value.", (Object)attribute.getValue());
            request.setSOAP11Actor(attribute.getValue());
        } else {
            this.log.debug("Unknown attribute {} = {}, ignored.", (Object)attrName.toString(), (Object)attribute.getValue());
        }
    }
}

