/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile.soap;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.glite.sts.profile.soap.xmlobject.Framework;
import org.glite.sts.profile.soap.xmlobject.FrameworkBuilder;
import org.glite.sts.profile.soap.xmlobject.Request;
import org.glite.sts.profile.soap.xmlobject.RequestBuilder;
import org.glite.sts.profile.soap.xmlobject.Status;
import org.glite.sts.profile.soap.xmlobject.StatusBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Detail;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultActor;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.soap11.FaultString;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wsaddressing.Action;
import org.opensaml.soap.wsaddressing.MessageID;
import org.opensaml.soap.wsaddressing.RelatesTo;
import org.opensaml.soap.wsaddressing.WSAddressingObjectBuilder;
import org.opensaml.soap.wstrust.RequestSecurityToken;
import org.opensaml.soap.wstrust.UseKey;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyValue;
import org.opensaml.xmlsec.signature.RSAKeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SoapActionSupport {
    private SoapActionSupport() {
    }

    @Nonnull
    public static Body addBodytoEnvelope(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Envelope envelope) {
        Body body = envelope.getBody();
        if (body == null) {
            SOAPObjectBuilder builder = (SOAPObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Body.DEFAULT_ELEMENT_NAME);
            body = (Body)builder.buildObject();
            envelope.setBody(body);
            SoapActionSupport.getLogger().debug("Action {}: Envelope did not already contain a Body, one was added", (Object)action.getId());
        } else {
            SoapActionSupport.getLogger().debug("Action {}: Envelope already contains a Body, nothing was done", (Object)action.getId());
        }
        return body;
    }

    @Nonnull
    public static Header addHeadertoEnvelope(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Envelope envelope) {
        Header header = envelope.getHeader();
        if (header == null) {
            SOAPObjectBuilder builder = (SOAPObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Header.DEFAULT_ELEMENT_NAME);
            header = (Header)builder.buildObject();
            envelope.setHeader(header);
            SoapActionSupport.getLogger().debug("Action {}: Envelope did not already contain a Header, one was added", (Object)action.getId());
        } else {
            SoapActionSupport.getLogger().debug("Action {}: Envelope already contains a Header, nothing was done", (Object)action.getId());
        }
        return header;
    }

    @Nonnull
    public static Action addActionToHeader(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Header header) {
        WSAddressingObjectBuilder builder = (WSAddressingObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Action.ELEMENT_NAME);
        Action soapAction = (Action)builder.buildObject();
        header.getUnknownXMLObjects().add(soapAction);
        SoapActionSupport.getLogger().debug("Action {}: Action added to a Header", (Object)action.getId());
        return soapAction;
    }

    @Nonnull
    public static MessageID addMessageIDToHeader(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Header header, @Nonnull String messageIDValue) {
        WSAddressingObjectBuilder builder = (WSAddressingObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(MessageID.ELEMENT_NAME);
        MessageID messageID = (MessageID)builder.buildObject();
        messageID.setValue(messageIDValue);
        header.getUnknownXMLObjects().add(messageID);
        SoapActionSupport.getLogger().debug("Action {}: MessageID {} added to a Header", (Object)action.getId(), (Object)messageIDValue);
        return messageID;
    }

    @Nonnull
    public static RelatesTo addRelatesToToHeader(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Header header, @Nonnull String relatesToValue) {
        WSAddressingObjectBuilder builder = (WSAddressingObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(RelatesTo.ELEMENT_NAME);
        RelatesTo relatesTo = (RelatesTo)builder.buildObject();
        relatesTo.setValue(relatesToValue);
        header.getUnknownXMLObjects().add(relatesTo);
        SoapActionSupport.getLogger().debug("Action {}: RelatesTo {} added to a Header", (Object)action.getId(), (Object)relatesToValue);
        return relatesTo;
    }

    @Nonnull
    public static Framework addFrameworkHeader(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Header header, @Nonnull String version) {
        FrameworkBuilder builder = (FrameworkBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Framework.DEFAULT_ELEMENT_NAME);
        Framework framework = builder.buildObject();
        framework.setVersion(version);
        header.getUnknownXMLObjects().add(framework);
        SoapActionSupport.getLogger().debug("Action {}: Framework version {} added to a Header", (Object)action.getId(), (Object)version);
        return framework;
    }

    @Nonnull
    public static Fault addFaultToBody(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Body body) {
        SOAPObjectBuilder builder = (SOAPObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Fault.DEFAULT_ELEMENT_NAME);
        Fault fault = (Fault)builder.buildObject();
        SoapActionSupport.addFaultMessage(action, fault);
        SoapActionSupport.addFaultCode(action, fault);
        SoapActionSupport.addFaultDetail(action, fault);
        body.getUnknownXMLObjects().add(fault);
        SoapActionSupport.getLogger().debug("Action {}: Fault {} added to a Body", (Object)action.getId(), (Object)fault.toString());
        return fault;
    }

    @Nonnull
    public static FaultActor addFaultActor(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Fault fault) {
        SOAPObjectBuilder builder = (SOAPObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(FaultActor.DEFAULT_ELEMENT_NAME);
        FaultActor faultActor = (FaultActor)builder.buildObject();
        fault.setActor(faultActor);
        SoapActionSupport.getLogger().debug("Action {}: FaultActor {} added to a Fault", (Object)action.getId(), (Object)faultActor.toString());
        return faultActor;
    }

    @Nonnull
    public static FaultCode addFaultCode(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Fault fault) {
        SOAPObjectBuilder builder = (SOAPObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(FaultCode.DEFAULT_ELEMENT_NAME);
        FaultCode faultCode = (FaultCode)builder.buildObject();
        fault.setCode(faultCode);
        SoapActionSupport.getLogger().debug("Action {}: FaultCode {} added to a Fault", (Object)action.getId(), (Object)faultCode.toString());
        return faultCode;
    }

    @Nonnull
    public static Detail addFaultDetail(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Fault fault) {
        SOAPObjectBuilder builder = (SOAPObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Detail.DEFAULT_ELEMENT_NAME);
        Detail faultDetail = (Detail)builder.buildObject();
        fault.setDetail(faultDetail);
        SoapActionSupport.getLogger().debug("Action {}: Detail {} added to a Fault", (Object)action.getId(), (Object)faultDetail.toString());
        return faultDetail;
    }

    @Nonnull
    public static FaultString addFaultMessage(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Fault fault) {
        SOAPObjectBuilder builder = (SOAPObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(FaultString.DEFAULT_ELEMENT_NAME);
        FaultString faultString = (FaultString)builder.buildObject();
        fault.setMessage(faultString);
        SoapActionSupport.getLogger().debug("Action {}: Message {} added to a Fault", (Object)action.getId(), (Object)faultString.toString());
        return faultString;
    }

    @Nonnull
    public static Status addStatusToDetail(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Detail detail) {
        StatusBuilder builder = (StatusBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status status = builder.buildObject();
        detail.getUnknownXMLObjects().add(status);
        SoapActionSupport.getLogger().debug("Action {}: Status {} added to a Detail", (Object)action.getId(), (Object)status.toString());
        return status;
    }

    @Nonnull
    public static Request addPaosRequestToHeader(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Header header) {
        RequestBuilder builder = (RequestBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Request.DEFAULT_ELEMENT_NAME);
        Request request = builder.buildObject();
        header.getUnknownXMLObjects().add(request);
        SoapActionSupport.getLogger().debug("Action {}: PAOS request added to a Header", (Object)action.getId());
        return request;
    }

    public static RSAPublicKey getPublicKeyFromEnvelope(@Nonnull AbstractProfileAction<?, ?> action, Envelope envelope) {
        Logger log = SoapActionSupport.getLogger();
        RSAKeyValue rsaValue = SoapActionSupport.getRSAKeyValueFromEnvelope(action, envelope);
        if (rsaValue == null) {
            log.debug("Action {}: No single RSAKeyValue found!", (Object)action.getId());
            return null;
        }
        log.debug("Action {}: RSAKeyValue was found, reading the modulus and the exponent", (Object)action.getId());
        if (rsaValue.getModulus() != null && rsaValue.getExponent() != null) {
            String modulus = rsaValue.getModulus().getValue();
            String exponent = rsaValue.getExponent().getValue();
            try {
                RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(Base64.decode((String)modulus)), new BigInteger(Base64.decode((String)exponent)));
                return (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(keySpec);
            }
            catch (Base64DecodingException e) {
                log.error("Action {}: Could not decode modulus and/or exponent", (Object)action.getId(), (Object)e);
            }
            catch (InvalidKeySpecException e) {
                log.error("Action {}: Internal error with key spec definitions", (Object)action.getId(), (Object)e);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("Action {}: Internal error: RSA algorithm set as invalid", (Object)action.getId(), (Object)e);
            }
        } else {
            log.debug("Action {}: No modulus and/or exponent found for the RSAKeyValue!", (Object)action.getId());
        }
        return null;
    }

    public static RSAKeyValue getRSAKeyValueFromEnvelope(@Nonnull AbstractProfileAction<?, ?> action, Envelope envelope) {
        Logger log = SoapActionSupport.getLogger();
        RequestSecurityToken rst = SoapActionSupport.getRequestSecurityTokenFromBody(envelope.getBody());
        if (rst == null) {
            log.debug("Action {}: No RST found from the envelope body", (Object)action.getId());
            return null;
        }
        UseKey useKey = SoapActionSupport.getUseKeyFromRequestSecurityToken(rst);
        if (useKey == null) {
            log.debug("Action {}: No single UseKey found from the RST", (Object)action.getId());
            return null;
        }
        KeyInfo keyInfo = SoapActionSupport.getKeyInfoFromUseKey(useKey);
        if (keyInfo == null) {
            log.debug("Action {}: No single KeyInfo found from the UseKey", (Object)action.getId());
            return null;
        }
        return SoapActionSupport.getRSAKeyValueFromKeyInfo(keyInfo);
    }

    public static RequestSecurityToken getRequestSecurityTokenFromBody(Body body) {
        List objects = body.getUnknownXMLObjects(RequestSecurityToken.ELEMENT_NAME);
        if (objects.size() == 1) {
            return (RequestSecurityToken)objects.get(0);
        }
        return null;
    }

    public static UseKey getUseKeyFromRequestSecurityToken(RequestSecurityToken rst) {
        List objects = rst.getUnknownXMLObjects(UseKey.ELEMENT_NAME);
        if (objects.size() == 1) {
            return (UseKey)objects.get(0);
        }
        return null;
    }

    public static KeyInfo getKeyInfoFromUseKey(UseKey useKey) {
        XMLObject keyInfo = useKey.getUnknownXMLObject();
        if (keyInfo instanceof KeyInfo) {
            return (KeyInfo)keyInfo;
        }
        return null;
    }

    public static RSAKeyValue getRSAKeyValueFromKeyInfo(KeyInfo keyInfo) {
        List keyValues = keyInfo.getKeyValues();
        if (keyValues.size() == 1) {
            return ((KeyValue)keyValues.get(0)).getRSAKeyValue();
        }
        return null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SoapActionSupport.class);
    }
}

