/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile.saml;

import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.ecp.Request;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlActionSupport {
    @Nonnull
    public static Request addEcpRequestToHeader(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Header header) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Request.DEFAULT_ELEMENT_NAME);
        Request request = (Request)builder.buildObject();
        header.getUnknownXMLObjects().add(request);
        SamlActionSupport.getLogger().debug("Action {}: ECP request added to a Header", (Object)action.getId());
        return request;
    }

    @Nonnull
    public static Issuer buildIssuer(@Nonnull AbstractProfileAction<?, ?> action, String value) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)builder.buildObject();
        issuer.setValue(value);
        SamlActionSupport.getLogger().debug("Action {}: Issuer constructed.", (Object)action.getId());
        return issuer;
    }

    @Nonnull
    public static AuthnRequest addAuthnRequestToBody(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Body body) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest request = (AuthnRequest)builder.buildObject();
        body.getUnknownXMLObjects().add(request);
        SamlActionSupport.getLogger().debug("Action {}: authentication request added to a Body", (Object)action.getId());
        return request;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SamlActionSupport.class);
    }
}

