/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile.ecp;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.profile.xmlsec.XmlSecActionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Element;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class SignAuthnRequestInEnvelope
extends AbstractProfileAction<Object, Envelope> {
    private final Logger log = LoggerFactory.getLogger(SignAuthnRequestInEnvelope.class);
    private Credential credential;

    public SignAuthnRequestInEnvelope(String certificateFile, String privateKeyFile) throws ProfileException {
        this(certificateFile, privateKeyFile, null);
    }

    public SignAuthnRequestInEnvelope(String certificateFile, String privateKeyFile, String password) throws ProfileException {
        try {
            X509Certificate cert = CertificateUtils.loadCertificate((InputStream)new FileInputStream(certificateFile), (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
            PrivateKey privKey = password == null ? CertificateUtils.loadPrivateKey((InputStream)new FileInputStream(privateKeyFile), (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM, null) : CertificateUtils.loadPrivateKey((InputStream)new FileInputStream(privateKeyFile), (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM, (char[])password.toCharArray());
            this.credential = new BasicX509Credential(cert, privKey);
        }
        catch (FileNotFoundException fnfe) {
            this.log.error("Action {}: Certificate and/or private key file not found, exiting.", (Object)this.getId());
        }
        catch (IOException ioe) {
            this.log.error("Action {}: Could not load certificate and/or private key, exiting.", (Object)this.getId());
        }
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Object, Envelope> profileRequestContext) throws ProfileException {
        MessageContext outboundMessageCtx = profileRequestContext.getOutboundMessageContext();
        Envelope envelope = (Envelope)outboundMessageCtx.getMessage();
        if (envelope == null) {
            this.log.debug("Action {}: Outbound message in the context is null", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        AuthnRequest authnRequest = this.getAuthnRequestFromBody(envelope.getBody());
        try {
            Signature signature = XmlSecActionSupport.buildSignatureObject(this, this.credential);
            authnRequest.setSignature(signature);
            this.marshall(authnRequest);
            Signer.signObject((Signature)signature);
        }
        catch (Exception e) {
            this.log.error("Could not load cert/key or sign", (Throwable)e);
            throw new ProfileException("Could not load cert/key or sign", e);
        }
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected AuthnRequest getAuthnRequestFromBody(Body body) {
        return (AuthnRequest)body.getUnknownXMLObjects(AuthnRequest.DEFAULT_ELEMENT_NAME).get(0);
    }

    protected Element marshall(AuthnRequest object) {
        MarshallerFactory MarshallerFactory2 = XMLObjectProviderRegistrySupport.getMarshallerFactory();
        Marshaller marshaller = MarshallerFactory2.getMarshaller(object.getElementQName());
        Element element = null;
        try {
            element = marshaller.marshall((XMLObject)object);
        }
        catch (MarshallingException e) {
            this.log.debug("Could not marshall AuthnRequest element", (Throwable)e);
            return null;
        }
        return element;
    }
}

