/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile.ecp;

import java.util.ArrayList;
import java.util.Collection;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.glite.sts.profile.config.EcpProfileConfiguration;
import org.opensaml.messaging.context.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed")})
public class InitializeProfileContext
extends AbstractIdentifiableInitializableComponent
implements Action,
IdentifiableComponent {
    private final Logger log = LoggerFactory.getLogger(InitializeProfileContext.class);
    private String relyingPartyId;
    private String relyingPartyConfigurationId;
    private String samlEntityId;

    public InitializeProfileContext(String rpId, String rpConfigId, String entityId) {
        this.setId(((Object)((Object)this)).getClass().getName());
        this.relyingPartyId = (String)Constraint.isNotNull((Object)rpId, (String)"Relying party context id cannot be null!");
        this.relyingPartyConfigurationId = (String)Constraint.isNotNull((Object)rpConfigId, (String)"Relying party configuration id cannot be null!");
        this.samlEntityId = (String)Constraint.isNotNull((Object)entityId, (String)"Relying party entity id cannot be null!");
    }

    public org.springframework.webflow.execution.Event execute(RequestContext context) throws Exception {
        ProfileRequestContext profileContext = new ProfileRequestContext();
        profileContext.setOutboundMessageContext(new MessageContext());
        RelyingPartyContext rpCtx = new RelyingPartyContext(this.relyingPartyId);
        profileContext.addSubcontext(rpCtx);
        rpCtx.setProfileConfiguration(InitializeProfileContext.buildProfileConfiguration());
        rpCtx.setRelyingPartyConfiguration(new RelyingPartyConfiguration(this.relyingPartyConfigurationId, this.samlEntityId, InitializeProfileContext.buildProfileConfigurations()));
        context.getConversationScope().put(ProfileRequestContext.BINDING_KEY, profileContext);
        this.log.debug("Action {}: Profile context initialized and attached to Spring request context", (Object)this.getId());
        return ActionSupport.buildProceedEvent(this);
    }

    public static Collection<ProfileConfiguration> buildProfileConfigurations() {
        ArrayList<ProfileConfiguration> profileConfigs = new ArrayList<ProfileConfiguration>();
        profileConfigs.add(InitializeProfileContext.buildProfileConfiguration());
        return profileConfigs;
    }

    public static EcpProfileConfiguration buildProfileConfiguration() {
        SecurityConfiguration securityConfig = new SecurityConfiguration();
        EcpProfileConfiguration ecpConfig = new EcpProfileConfiguration();
        ecpConfig.setSecurityConfiguration(securityConfig);
        return ecpConfig;
    }
}

