/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile.ecp;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="error")})
public class CheckPaosHeaders
extends AbstractProfileAction<Object, Object> {
    private final Logger log = LoggerFactory.getLogger(CheckPaosHeaders.class);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Object, Object> profileRequestContext) throws ProfileException {
        String supportsService = "\"urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp\"";
        String supportsPaosV_1_1 = "ver=\"urn:liberty:paos:2003-08\"";
        String acceptHeader = httpRequest.getHeader("Accept");
        this.log.debug("Action {}: accept header: {}", (Object)this.getId(), (Object)acceptHeader);
        if (acceptHeader == null || !acceptHeader.contains("application/vnd.paos+xml")) {
            this.log.debug("Action {}: headers didn't advertise acceptance of PAOS", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "error");
        }
        String paosHeader = httpRequest.getHeader("PAOS");
        this.log.debug("Action {}: got PAOS-header {}", (Object)this.getId(), (Object)paosHeader);
        if (paosHeader == null || !paosHeader.contains(supportsPaosV_1_1) || !paosHeader.contains(supportsService)) {
            this.log.debug("Action {}: No supported profile found from the PAOS headers", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "error");
        }
        this.log.debug("Action {}: Request was from an ECP client, all done.", (Object)this.getId());
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }
}

