/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile.ecp;

import com.google.common.base.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.idp.relyingparty.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.profile.saml.SamlActionSupport;
import org.glite.sts.saml.TrustedIdpMetadataService;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.saml.saml2.core.IDPList;
import org.opensaml.saml.saml2.ecp.Request;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class AddEcpRequestToEnvelope
extends AbstractProfileAction<Object, Envelope> {
    private final Logger log = LoggerFactory.getLogger(AddEcpRequestToEnvelope.class);
    private TrustedIdpMetadataService trustedIdpMetadataService;
    private Function<ProfileRequestContext<?, ?>, RelyingPartyContext> relyingPartyContextLookupStrategy;

    public AddEcpRequestToEnvelope(TrustedIdpMetadataService trustedIdpMetadata) {
        this.trustedIdpMetadataService = trustedIdpMetadata;
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class, false);
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Object, Envelope> profileRequestContext) throws ProfileException {
        MessageContext outboundMessageCtx = profileRequestContext.getOutboundMessageContext();
        Envelope envelope = (Envelope)outboundMessageCtx.getMessage();
        if (envelope == null) {
            this.log.debug("Action {}: Outbound message in the context is null", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        Header header = envelope.getHeader();
        RelyingPartyContext relyingPartyCtx = (RelyingPartyContext)((Object)this.relyingPartyContextLookupStrategy.apply(profileRequestContext));
        Request request = SamlActionSupport.addEcpRequestToHeader(this, header);
        IDPList idpList = this.trustedIdpMetadataService.getTrustedIdpList();
        idpList.detach();
        request.setIDPList(idpList);
        request.setSOAP11Actor("http://schemas.xmlsoap.org/soap/actor/next");
        request.setSOAP11MustUnderstand(Boolean.TRUE);
        request.setIssuer(SamlActionSupport.buildIssuer(this, relyingPartyCtx.getConfiguration().getResponderEntityId()));
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }
}

