/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.navigate.WebflowRequestContextHttpServletResponseLookup;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SendErrorResponse
extends AbstractIdentifiableInitializableComponent
implements Action,
IdentifiableComponent {
    public static final String DEFAULT_ERROR_MESSAGE = "Request not understood, this is a SOAP-based Web Service.";
    private final Logger log = LoggerFactory.getLogger(SendErrorResponse.class);
    private Function<RequestContext, HttpServletResponse> httpResponseLookupStrategy;
    private String errorMessage;

    public SendErrorResponse() {
        this(DEFAULT_ERROR_MESSAGE);
    }

    public SendErrorResponse(String message) {
        this.setId(((Object)((Object)this)).getClass().getName());
        this.errorMessage = (String)Constraint.isNotNull((Object)message, (String)"The error message cannot be null!");
        this.httpResponseLookupStrategy = new WebflowRequestContextHttpServletResponseLookup();
    }

    public Event execute(RequestContext springRequestContext) throws Exception {
        return this.execute(springRequestContext, null);
    }

    public Event execute(RequestContext springRequestContext, String message) throws Exception {
        this.log.info("Action {}: Ignoring a non-supported request message and closing the flow", (Object)this.getId());
        HttpServletResponse httpResponse = (HttpServletResponse)this.httpResponseLookupStrategy.apply((Object)springRequestContext);
        try {
            if (message != null) {
                httpResponse.getWriter().write(message);
            } else {
                httpResponse.getWriter().write(this.errorMessage);
            }
        }
        catch (IOException e) {
            this.log.error("Could not write to the HTTP response", (Throwable)e);
        }
        springRequestContext.getExternalContext().recordResponseComplete();
        return ActionSupport.buildProceedEvent(this);
    }
}

