/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.attribute.Attribute;
import net.shibboleth.idp.attribute.AttributeContext;
import net.shibboleth.idp.attribute.AttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.authn.AuthenticationRequestContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.glite.sts.authn.UsernamePasswordContext;
import org.ldaptive.BindOperation;
import org.ldaptive.BindRequest;
import org.ldaptive.Connection;
import org.ldaptive.Credential;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.pool.ConnectionPool;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class ResolveAttributesFromLdap
extends AbstractProfileAction<Envelope, Envelope> {
    private final Logger log = LoggerFactory.getLogger(ResolveAttributesFromLdap.class);
    public static final String DEFAULT_UID_ATTRIBUTE = "uid";
    private ConnectionPool ldapConnectionPool;
    private String ldapBaseDn;
    private String ldapUidAttributeName;
    private String ldapBindDn;
    private Credential ldapBindCredential;
    private Function<ProfileRequestContext<Envelope, Envelope>, AuthenticationRequestContext> authnCtxLookupStrategy = new ChildContextLookup(AuthenticationRequestContext.class, false);
    private Function<AuthenticationRequestContext, UsernamePasswordContext> usernamePasswordCtxLookupStrategy = new ChildContextLookup(UsernamePasswordContext.class, false);

    public ResolveAttributesFromLdap(ConnectionPool connectionPool, String baseDn) {
        this(connectionPool, baseDn, DEFAULT_UID_ATTRIBUTE, null, null);
    }

    public ResolveAttributesFromLdap(ConnectionPool connectionPool, String baseDn, String uid) {
        this(connectionPool, baseDn, uid, null, null);
    }

    public ResolveAttributesFromLdap(ConnectionPool connectionPool, String baseDn, String bindDn, String bindCredential) {
        this(connectionPool, baseDn, DEFAULT_UID_ATTRIBUTE, bindDn, bindCredential);
    }

    public ResolveAttributesFromLdap(ConnectionPool connectionPool, String baseDn, String uid, String bindDn, String bindCredential) {
        this.ldapConnectionPool = connectionPool;
        this.ldapBaseDn = (String)Constraint.isNotNull((Object)baseDn, (String)"Base DN must be configured to the LDAP connection");
        this.ldapUidAttributeName = (String)Constraint.isNotNull((Object)uid, (String)"The uid attribute name for the LDAP cannot be null");
        this.ldapBindDn = bindDn;
        this.ldapBindCredential = bindCredential != null ? new Credential(bindCredential) : null;
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Envelope> profileRequestContext) throws ProfileException {
        MessageContext outMessageContext;
        MessageContext inMessageContext = profileRequestContext.getInboundMessageContext();
        if (inMessageContext == null) {
            this.log.debug("Action {}: inbound message context is null!", (Object)this.getId());
            ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        if ((outMessageContext = profileRequestContext.getOutboundMessageContext()) == null) {
            this.log.debug("Action {}: outbound message context is null!", (Object)this.getId());
            ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        AuthenticationRequestContext authnContext = (AuthenticationRequestContext)((Object)this.authnCtxLookupStrategy.apply(profileRequestContext));
        UsernamePasswordContext usernameContext = (UsernamePasswordContext)((Object)this.usernamePasswordCtxLookupStrategy.apply((Object)authnContext));
        Collection<LdapAttribute> ldapAttributes = this.resolveAttributes(usernameContext);
        Vector<Attribute> attributes = this.convertAttributes(ldapAttributes);
        AttributeContext attributeContext = new AttributeContext();
        attributeContext.setAttributes(attributes);
        profileRequestContext.addSubcontext(attributeContext, true);
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<LdapAttribute> resolveAttributes(UsernamePasswordContext usernameContext) {
        LdapEntry entry;
        Credential bindCredential;
        String bindDn;
        Connection conn;
        String username = usernameContext.getUsername();
        try {
            conn = this.ldapConnectionPool.getConnection();
        }
        catch (LdapException e) {
            this.log.error("Action {}: Could not get a connection from the pool!", (Object)this.getId());
            this.log.debug("Caused by", (Throwable)e);
            return null;
        }
        if (this.ldapBindDn == null) {
            bindDn = this.ldapUidAttributeName + "=" + username + "," + this.ldapBaseDn;
            if (usernameContext.isPasswordHashed()) {
                this.log.warn("Incoming password is hashed, ldapBindDn must be configured in order to obtain the attributes for the user!");
                return null;
            }
            bindCredential = new Credential(usernameContext.getPassword());
        } else {
            bindDn = this.ldapBindDn;
            bindCredential = this.ldapBindCredential;
        }
        try {
            conn.open();
            BindOperation bind = new BindOperation(conn);
            this.log.debug("Action {}: Attempting to authenticate {}", (Object)this.getId(), (Object)bindDn);
            bind.execute((Request)new BindRequest(bindDn, bindCredential));
            SearchOperation search = new SearchOperation(conn);
            SearchRequest req = new SearchRequest(this.ldapBaseDn, "(uid=" + username + ")");
            SearchResult result = (SearchResult)search.execute((Request)req).getResult();
            entry = result.getEntry();
        }
        catch (LdapException e) {
            this.log.warn("Action {}: Could not access the LDAP directory: {}", (Object)this.getId(), (Object)e.getMessage());
            this.log.debug("Caused by", (Throwable)e);
            Collection<LdapAttribute> collection = null;
            return collection;
        }
        finally {
            conn.close();
        }
        if (entry == null) {
            return null;
        }
        return entry.getAttributes();
    }

    protected Vector<Attribute> convertAttributes(Collection<LdapAttribute> ldapAttributes) {
        Vector<Attribute> result = new Vector<Attribute>();
        if (ldapAttributes != null) {
            for (LdapAttribute ldapAttribute : ldapAttributes) {
                this.log.debug("Action {}: Adding an attribute {}", (Object)this.getId(), (Object)ldapAttribute.getName());
                result.add(this.generateAttribute(ldapAttribute.getName(), ldapAttribute.getStringValue()));
            }
        } else {
            this.log.debug("Action {}: No attributes found to be converted", (Object)this.getId());
        }
        return result;
    }

    protected Attribute generateAttribute(String attributeId, String attributeValue) {
        Attribute attribute = new Attribute(attributeId);
        this.log.debug("Action {}: Converting an attribute {}", (Object)this.getId(), (Object)attributeId);
        StringAttributeValue attrValue = new StringAttributeValue(attributeValue);
        Vector<AttributeValue> list = new Vector<AttributeValue>();
        list.add(attrValue);
        attribute.setValues(list);
        return attribute;
    }
}

